/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.shortcuts.internal;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugins.rest.api.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.api.json.JsonMarshallingException;
import com.atlassian.plugins.shortcuts.api.KeyboardShortcut;
import com.atlassian.plugins.shortcuts.api.KeyboardShortcutManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.transformer.TransformableResource;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.transformer.TransformerUrlBuilder;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.webresource.spi.transformer.WebResourceTransformerFactory;
import com.fasterxml.jackson.annotation.JsonRawValue;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyboardShortcutsWebResourceTransformer
implements WebResourceTransformerFactory,
TransformerUrlBuilder,
UrlReadingWebResourceTransformer {
    private static final Logger log = LoggerFactory.getLogger(KeyboardShortcutsWebResourceTransformer.class);
    private static final String KEYBOARD_SHORTCUTS_HASH = "keyboard-shortcuts-hash";
    private static final String KEYBOARD_SHORTCUTS_REGEX = "keyboard_shortcuts\\s*\\(\\s*\\)";
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final I18nResolver i18nResolver;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;

    public KeyboardShortcutsWebResourceTransformer(KeyboardShortcutManager keyboardShortcutManager, I18nResolver i18nResolver, JaxbJsonMarshaller jaxbJsonMarshaller) {
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.i18nResolver = i18nResolver;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
    }

    public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
        return new CharSequenceDownloadableResource(transformableResource.nextResource()){

            protected CharSequence transform(CharSequence original) {
                return KeyboardShortcutsWebResourceTransformer.this.doTransform(original);
            }
        };
    }

    private CharSequence doTransform(CharSequence original) {
        List<KeyboardShortcut> shortcuts = this.keyboardShortcutManager.getAllShortcuts();
        try {
            String jsonString = this.jaxbJsonMarshaller.marshal((Object)new Shortcuts(shortcuts, this.i18nResolver));
            return original.toString().replaceAll(KEYBOARD_SHORTCUTS_REGEX, jsonString);
        }
        catch (JsonMarshallingException e) {
            log.warn("failed serializing keyboard shortcuts", (Throwable)e);
            return original.toString().replaceAll(KEYBOARD_SHORTCUTS_REGEX, "console.error('failed serializing keyboard shortcuts, see application logs for details');");
        }
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        urlBuilder.addToQueryString(KEYBOARD_SHORTCUTS_HASH, this.keyboardShortcutManager.getShortcutsHash());
    }

    public Set<String> allUsedQueryParameters() {
        return Set.of(KEYBOARD_SHORTCUTS_HASH);
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return this;
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return this;
    }

    @XmlRootElement
    public static class Shortcuts {
        @XmlElement
        final List<Shortcut> shortcuts = new ArrayList<Shortcut>();

        private Shortcuts() {
        }

        public Shortcuts(List<KeyboardShortcut> origShortcuts, I18nResolver i18nResolver) {
            for (KeyboardShortcut origShortcut : origShortcuts) {
                this.shortcuts.add(new Shortcut(origShortcut, i18nResolver));
            }
        }
    }

    @XmlRootElement
    public static class Shortcut {
        @XmlElement
        private Set<List<String>> keys;
        @XmlElement
        private String context;
        @XmlElement
        private String op;
        @XmlElement
        private String param;
        @XmlElement
        private String descKey;
        @XmlElement
        private String description;
        @XmlElement
        private Boolean hidden;
        @XmlElement
        @JsonRawValue
        private String function;

        private Shortcut() {
        }

        public Shortcut(KeyboardShortcut shortcut, I18nResolver i18nResolver) {
            this.keys = new LinkedHashSet<List<String>>(shortcut.getShortcuts());
            this.context = shortcut.getContext();
            this.op = shortcut.getOperation().getType().name();
            if ("evaluate".equals(this.op) || "execute".equals(this.op)) {
                this.function = "function(){" + shortcut.getParameter() + "}";
            } else {
                this.param = shortcut.getParameter();
            }
            this.descKey = shortcut.getDescriptionI18nKey();
            String description = i18nResolver.getText(this.descKey);
            if (description == null || description.equals(this.descKey)) {
                description = shortcut.getDefaultDescription();
            }
            this.description = description;
            this.hidden = shortcut.isHidden();
        }
    }
}

