/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.boot;

import com.atlassian.bitbucket.mesh.MeshDatabaseWiring;
import com.atlassian.bitbucket.mesh.boot.ApplicationMode;
import com.atlassian.bitbucket.mesh.boot.LogbackApplicationListener;
import com.atlassian.bitbucket.mesh.boot.NettyConfigApplicationListener;
import com.atlassian.bitbucket.mesh.boot.ProfilingApplicationListener;
import com.atlassian.bitbucket.mesh.grpc.MeshGrpcWiring;
import com.atlassian.bitbucket.mesh.io.MoreFiles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.JvmMetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.LogbackMetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.SystemMetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.datadog.DatadogMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.dynatrace.DynatraceMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.influx.InfluxMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.jmx.JmxMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.signalfx.SignalFxMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.statsd.StatsdMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.admin.SpringApplicationAdminJmxAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableScheduling
@ImportAutoConfiguration(value={CompositeMeterRegistryAutoConfiguration.class, DatadogMetricsExportAutoConfiguration.class, DynatraceMetricsExportAutoConfiguration.class, InfluxMetricsExportAutoConfiguration.class, JmxAutoConfiguration.class, JmxMetricsExportAutoConfiguration.class, JvmMetricsAutoConfiguration.class, LogbackMetricsAutoConfiguration.class, MetricsAutoConfiguration.class, SignalFxMetricsExportAutoConfiguration.class, StatsdMetricsExportAutoConfiguration.class, SpringApplicationAdminJmxAutoConfiguration.class, SystemMetricsAutoConfiguration.class})
@Import(value={MeshDatabaseWiring.class, MeshGrpcWiring.class})
@SpringBootApplication
public class MeshApplication {
    private static final Logger log = LoggerFactory.getLogger(MeshApplication.class);
    private static ApplicationContext applicationContext;

    public static void main(String[] args) {
        DefaultApplicationArguments arguments;
        List commands;
        if (SystemUtils.IS_OS_WINDOWS) {
            log.error("{} does not support Windows.", (Object)"Mesh");
            System.exit(1);
        }
        if ((commands = (arguments = new DefaultApplicationArguments(args)).getNonOptionArgs()).isEmpty() || "start".equals(commands.get(0))) {
            MeshApplication.start((String[])args);
        } else if ("stop".equals(commands.get(0))) {
            MeshApplication.stop();
        } else {
            log.warn("Unexpected command(s): {}", (Object)commands);
        }
    }

    private static void createTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            try {
                MoreFiles.mkdir((Path)Paths.get(tmpDir, new String[0]));
            }
            catch (IllegalStateException e) {
                log.error("java.io.tmpdir ({}) could not be created", (Object)tmpDir, (Object)e.getCause());
                System.exit(1);
            }
        }
    }

    private static String getConfigLocations(ApplicationMode mode) {
        StringBuilder builder = new StringBuilder().append("classpath:/application-private.properties,").append("classpath:/application-public.properties,");
        mode.getProperties().ifPresent(properties -> builder.append("classpath:/").append((String)properties).append(','));
        return builder.append("optional:file:${mesh.home}/,").append("optional:file:${mesh.home}/mesh-node.properties").toString();
    }

    private static ApplicationMode detectMode(String[] args) {
        String propertyValue = null;
        for (String arg : args) {
            if (!arg.startsWith("--spring.profiles.active=")) continue;
            propertyValue = arg.substring(25);
            break;
        }
        if (propertyValue == null && (propertyValue = System.getProperty("spring.profiles.active")) == null) {
            propertyValue = System.getenv("SPRING_PROFILES_ACTIVE");
        }
        if (propertyValue != null) {
            String[] profiles;
            for (String profile : profiles = propertyValue.split(",")) {
                for (ApplicationMode mode : ApplicationMode.values()) {
                    if (!profile.equals(mode.getProfile())) continue;
                    return mode;
                }
            }
        }
        return ApplicationMode.STANDALONE;
    }

    private static void setSystemProperties(ApplicationMode mode) {
        System.setProperty("spring.boot.enableautoconfiguration", "false");
        System.setProperty("spring.config.name", "mesh");
        System.setProperty("spring.config.location", MeshApplication.getConfigLocations((ApplicationMode)mode));
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            System.setProperty("jna.tmpdir", tmpDir);
        }
    }

    private static void start(String[] args) {
        if (applicationContext == null) {
            ApplicationMode mode = MeshApplication.detectMode((String[])args);
            MeshApplication.setSystemProperties((ApplicationMode)mode);
            MeshApplication.createTmpDir();
            SpringApplication application = new SpringApplication(new Class[]{MeshApplication.class});
            application.addListeners(new ApplicationListener[]{new LogbackApplicationListener(), new NettyConfigApplicationListener(), new ProfilingApplicationListener()});
            application.setAdditionalProfiles(new String[]{mode.getProfile()});
            application.setBannerMode(Banner.Mode.OFF);
            applicationContext = application.run(args);
        } else {
            log.warn("Start command received, but the app is already running");
        }
    }

    private static void stop() {
        if (applicationContext == null) {
            log.warn("Stop command received, but the app is not running");
        } else {
            SpringApplication.exit((ApplicationContext)applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        }
    }
}

