/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.boot;

import com.atlassian.bitbucket.mesh.boot.config.DirectMemoryConfig;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.unit.DataSize;

/*
 * Exception performing whole class analysis ignored.
 */
public class NettyConfigApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
    private static final String PROP_GRPC_DIRECT_MEMORY_PREFIX = "grpc.direct-memory";
    private static final String PROP_NETTY_MAX_DIRECT_MEMORY = "io.netty.maxDirectMemory";
    private static final Logger log = LoggerFactory.getLogger(NettyConfigApplicationListener.class);

    public void onApplicationEvent(@Nonnull ApplicationEnvironmentPreparedEvent event) {
        Long configuredNettyMaxDirectMemory;
        ConfigurableEnvironment env = Objects.requireNonNull(event, "event").getEnvironment();
        long jvmMaxDirectMemory = NettyConfigApplicationListener.getMaxDirectMemory();
        DirectMemoryConfig directMemoryConfig = (DirectMemoryConfig)Binder.get((Environment)env).bindOrCreate("grpc.direct-memory", DirectMemoryConfig.class);
        long effectiveNettyMaxDirectMemory = Math.min(directMemoryConfig.getMax().toBytes() < 0L ? jvmMaxDirectMemory : directMemoryConfig.getMax().toBytes(), jvmMaxDirectMemory - directMemoryConfig.getReserved().toBytes());
        if (effectiveNettyMaxDirectMemory < 0L || effectiveNettyMaxDirectMemory > jvmMaxDirectMemory) {
            effectiveNettyMaxDirectMemory = jvmMaxDirectMemory - DataSize.parse((CharSequence)"50MB").toBytes();
        }
        if ((configuredNettyMaxDirectMemory = (Long)env.getProperty("io.netty.maxDirectMemory", Long.class)) != null) {
            if (configuredNettyMaxDirectMemory <= effectiveNettyMaxDirectMemory) {
                effectiveNettyMaxDirectMemory = configuredNettyMaxDirectMemory;
            } else {
                log.info("Configured direct memory limit for Netty is too high. Setting it to {} MB instead of {} MB.", (Object)DataSize.ofBytes((long)effectiveNettyMaxDirectMemory).toMegabytes(), (Object)DataSize.ofBytes((long)configuredNettyMaxDirectMemory).toMegabytes());
            }
        } else {
            log.debug("Setting direct memory limit for Netty to {}MB and reserving {}MB for other processes", (Object)DataSize.ofBytes((long)effectiveNettyMaxDirectMemory).toMegabytes(), (Object)directMemoryConfig.getReserved().toMegabytes());
        }
        System.setProperty("io.netty.maxDirectMemory", String.valueOf(effectiveNettyMaxDirectMemory));
    }

    @VisibleForTesting
    static long getMaxDirectMemory() {
        long maxDirectMemory = 0L;
        List<String> vmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : vmArgs) {
            Matcher m = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN.matcher(arg);
            if (!m.matches()) continue;
            String maxDirectMemoryArgument = String.format("%d%sB", Long.parseLong(m.group(1)), m.group(2).toUpperCase(Locale.ROOT));
            maxDirectMemory = DataSize.parse((CharSequence)maxDirectMemoryArgument).toBytes();
        }
        return maxDirectMemory > 0L ? maxDirectMemory : Runtime.getRuntime().maxMemory();
    }
}

