/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.boot;

import com.atlassian.util.profiling.ProfilerConfiguration;
import com.atlassian.util.profiling.Timers;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;

public class ProfilingApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment env = event.getEnvironment();
        ProfilerConfiguration configuration = Timers.getConfiguration();
        configuration.setEnabled(((Boolean)env.getProperty("profiling.enabled", Boolean.class, (Object)Boolean.FALSE)).booleanValue());
        configuration.setMinFrameTime((long)((Integer)env.getProperty("profiling.min-frame-time", Integer.class, (Object)0)).intValue(), TimeUnit.MILLISECONDS);
        configuration.setMinTraceTime((long)((Integer)env.getProperty("profiling.min-trace-time", Integer.class, (Object)0)).intValue(), TimeUnit.MILLISECONDS);
        configuration.setMaxFrameNameLength(Math.max(150, (Integer)env.getProperty("profiling.max-frame-name-length", Integer.class, (Object)300)));
    }
}

