/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.sidecar;

import com.atlassian.bitbucket.mesh.sidecar.SidecarChannel;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SidecarRunner
implements CommandLineRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SidecarRunner.class);
    private final SidecarChannel channel;
    private ApplicationContext applicationContext;

    public SidecarRunner(SidecarChannel channel) {
        this.channel = channel;
    }

    public void run(String ... args) throws IOException {
        this.channel.send("Ready");
        this.handleStdin();
        this.shutdown();
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void handleStdin() throws IOException {
        log.debug("Waiting for stdin to close");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ("ping".equalsIgnoreCase(line)) {
                    this.channel.send("pong");
                    continue;
                }
                log.warn("Unexpected stdin: {}", (Object)line);
            }
        }
    }

    private void shutdown() {
        log.info("Shutting down");
        Thread shutdown = new Thread(() -> SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]), "spring-shutdown");
        shutdown.setDaemon(true);
        shutdown.start();
        try {
            shutdown.join(TimeUnit.SECONDS.toMillis(30L));
            if (shutdown.isAlive()) {
                log.warn("The system failed to shutdown within 30s. The JVM will be abandoned");
            } else {
                log.info("Shutdown complete");
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for shutdown to complete. The JVM will be abandoned");
        }
    }
}

