/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments;

import com.atlassian.bitbucket.commit.BulkCommitsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsRequest;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.dmz.deployments.CommitDeploymentSearchRequest;
import com.atlassian.bitbucket.dmz.deployments.DeleteDeploymentRequest;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentService;
import com.atlassian.bitbucket.dmz.deployments.DeploymentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.dmz.deployments.GetDeploymentRequest;
import com.atlassian.bitbucket.dmz.deployments.PullRequestDeploymentSearchRequest;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentDeletedEvent;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.deployments.SimpleDeployment;
import com.atlassian.bitbucket.internal.deployments.dao.DeployedCommitDao;
import com.atlassian.bitbucket.internal.deployments.dao.DeploymentDao;
import com.atlassian.bitbucket.internal.deployments.event.AnalyticsDeploymentCreatedEvent;
import com.atlassian.bitbucket.internal.deployments.event.AnalyticsDeploymentUpdatedEvent;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestActivityType;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.UrlHrefUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@RequireFeature(value=StandardFeature.DEPLOYMENTS)
@Transactional(readOnly=true)
public class DefaultDeploymentService
implements DeploymentService {
    private static final int MAX_KEY_LENGTH = 255;
    private static final int MAX_RETRIES = 3;
    private static final int MAX_URL_LENGTH = 1024;
    private static final Logger log = LoggerFactory.getLogger(DefaultDeploymentService.class);
    private final CommitService commitService;
    private final DeployedCommitDao deployedCommitDao;
    private final DeploymentDao deploymentDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestService pullRequestService;
    private final TransactionTemplate transactionTemplate;

    public DefaultDeploymentService(CommitService commitService, DeployedCommitDao deployedCommitDao, DeploymentDao deploymentDao, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PermissionService permissionService, PullRequestService pullRequestService, PlatformTransactionManager platformTransactionManager) {
        this.commitService = commitService;
        this.deployedCommitDao = deployedCommitDao;
        this.deploymentDao = deploymentDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.permissionService = permissionService;
        this.pullRequestService = pullRequestService;
        this.transactionTemplate = new TransactionTemplate(platformTransactionManager, SpringTransactionUtils.definitionFor((int)0));
    }

    @Transactional
    public void delete(@Nonnull DeleteDeploymentRequest request) {
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
        this.validateCommitId(request.getCommitId());
        this.getInternalDeployment(request.getRepository(), request.getKey(), request.getEnvironmentKey(), request.getDeploymentSequenceNumber()).ifPresent(internalDeployment -> {
            this.validateCommitIdOnDeployment((InternalDeployment)internalDeployment, request.getCommitId());
            this.deploymentDao.delete(internalDeployment);
            Deployment deployment = this.convertToDeployment((InternalDeployment)internalDeployment);
            this.eventPublisher.publish((Object)new DeploymentDeletedEvent((Object)this, deployment));
        });
    }

    @Nonnull
    public Optional<Deployment> get(@Nonnull GetDeploymentRequest request) {
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_READ);
        this.validateCommitId(request.getCommitId());
        return this.getInternalDeployment(request.getRepository(), request.getKey(), request.getEnvironmentKey(), request.getDeploymentSequenceNumber()).map(internalDeployment -> {
            this.validateCommitIdOnDeployment((InternalDeployment)internalDeployment, request.getCommitId());
            return internalDeployment;
        }).map(this::convertToDeployment);
    }

    @Nonnull
    public Page<Deployment> search(@Nonnull PullRequestDeploymentSearchRequest request, @Nonnull PageRequest pageRequest) {
        ImmutableSet repoIds;
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        PullRequest pullRequest = request.getPullRequest();
        Repository fromRepo = pullRequest.getFromRef().getRepository();
        Repository toRepo = pullRequest.getToRef().getRepository();
        ImmutableSet.Builder commits = ImmutableSet.builder();
        commits.add((Object)pullRequest.getFromRef().getLatestCommit());
        if (pullRequest.getState() == PullRequestState.MERGED) {
            PageUtils.toStream(activityPageRequest -> this.pullRequestService.searchActivities(new PullRequestActivitySearchRequest.Builder(pullRequest).types(PullRequestActivityType.MERGE, new PullRequestActivityType[0]).build(), activityPageRequest), (int)25).findFirst().map(activity -> (PullRequestMergeActivity)activity).map(PullRequestMergeActivity::getCommit).map(MinimalCommit::getId).ifPresent(arg_0 -> ((ImmutableSet.Builder)commits).add(arg_0));
        }
        ImmutableSet.Builder repositoryIdsBuilder = new ImmutableSet.Builder();
        if (this.permissionService.hasRepositoryPermission(fromRepo, Permission.REPO_READ)) {
            repositoryIdsBuilder.add((Object)fromRepo.getId());
        }
        if (this.permissionService.hasRepositoryPermission(toRepo, Permission.REPO_READ)) {
            repositoryIdsBuilder.add((Object)toRepo.getId());
        }
        if ((repoIds = repositoryIdsBuilder.build()).isEmpty()) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.getDeployments((Set<Integer>)repoIds, (Set<String>)commits.build(), request.getState(), pageRequest);
    }

    @Nonnull
    public Page<Deployment> search(@Nonnull CommitDeploymentSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_READ);
        ImmutableSet repositoryIds = ImmutableSet.of((Object)request.getRepository().getId());
        Set<String> commitIds = Collections.singleton(request.getCommitId());
        return this.getDeployments((Set<Integer>)repositoryIds, commitIds, request.getState(), pageRequest);
    }

    @Nonnull
    @Transactional
    public Deployment set(@Nonnull DeploymentSetRequest request) {
        Objects.requireNonNull(request, "request");
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)request.getRepository());
        DeploymentEnvironmentSetRequest environmentRequest = request.getEnvironmentRequest();
        String deploymentKey = request.getKey();
        String environmentKey = request.getEnvironmentRequest().getKey();
        long sequenceNumber = request.getDeploymentSequenceNumber();
        this.permissionValidationService.validateForRepository((Repository)repository, Permission.REPO_READ);
        this.validateCommitId(request.getCommitId());
        this.validateKeys(deploymentKey, environmentKey);
        this.validateUrl(request.getUrl(), "url");
        environmentRequest.getUrl().ifPresent(environmentUrl -> this.validateUrl((URI)environmentUrl, "environment.url"));
        Commit toCommit = this.commitService.getCommit(new CommitRequest.Builder((Repository)repository, request.getCommitId()).maxMessageLength(0).build());
        int attempt = 1;
        while (true) {
            try {
                return (Deployment)this.transactionTemplate.execute(transactionStatus -> {
                    Optional<InternalDeployment> deploymentToUpdate = this.deploymentDao.get(repository, deploymentKey, environmentKey, sequenceNumber);
                    deploymentToUpdate.ifPresent(existing -> this.validateCommitIdOnDeployment((InternalDeployment)existing, request.getCommitId()));
                    Long deploymentId = deploymentToUpdate.map(InternalDeployment::getId).orElse(null);
                    Commit fromCommit = deploymentToUpdate.flatMap(InternalDeployment::getFromCommitId).map(existingCommitId -> this.toCommit(repository, (String)existingCommitId)).orElseGet(() -> this.getPreviousDeploymentCommitId(repository, deploymentKey, environmentKey, sequenceNumber).map(existingCommitId -> this.toCommit(repository, (String)existingCommitId)).orElse(null));
                    String fromCommitId = fromCommit == null ? null : fromCommit.getId();
                    InternalDeployment internalDeployment = this.deploymentDao.set(request, fromCommitId, deploymentId);
                    Deployment deployment = this.convertToDeployment(internalDeployment, fromCommit, toCommit);
                    this.eventPublisher.publish(deploymentToUpdate.isPresent() ? new AnalyticsDeploymentUpdatedEvent(this, deployment, request.getSourceTool()) : new AnalyticsDeploymentCreatedEvent(this, deployment, request.getSourceTool()));
                    return deployment;
                });
            }
            catch (ArgumentValidationException e) {
                throw e;
            }
            catch (Exception e) {
                if (attempt >= 3) {
                    throw e;
                }
                log.debug("Failed due to an exception. Retrying... (attempt {}/{})", new Object[]{attempt, 3, e});
                ++attempt;
                continue;
            }
            break;
        }
    }

    private Deployment convertToDeployment(InternalDeployment internalDeployment) {
        return this.convertToDeployment(internalDeployment, Collections.emptyMap());
    }

    private Deployment convertToDeployment(InternalDeployment internalDeployment, Commit fromCommit, Commit toCommit) {
        ImmutableMap.Builder commits = ImmutableMap.builder().put((Object)toCommit.getId(), (Object)toCommit);
        if (fromCommit != null && !fromCommit.getId().equals(toCommit.getId())) {
            commits.put((Object)fromCommit.getId(), (Object)fromCommit);
        }
        return this.convertToDeployment(internalDeployment, (Map<String, Commit>)commits.build());
    }

    private Deployment convertToDeployment(InternalDeployment internalDeployment, Map<String, Commit> commitMap) {
        MinimalCommit toCommit = this.getCommitFromMap(internalDeployment.getToCommitId(), commitMap);
        MinimalCommit fromCommit = internalDeployment.getFromCommitId().map(fromCommitId -> this.getCommitFromMap((String)fromCommitId, commitMap)).orElse(null);
        return new SimpleDeployment.Builder(internalDeployment, toCommit).fromCommit(fromCommit).build();
    }

    private MinimalCommit getCommitFromMap(String commitId, Map<String, Commit> commitMap) {
        MinimalCommit toCommit = (MinimalCommit)commitMap.get(commitId);
        if (toCommit == null) {
            toCommit = new SimpleMinimalCommit.Builder(commitId).build();
        }
        return toCommit;
    }

    private Page<Deployment> getDeployments(Set<Integer> repoIds, Set<String> commitIds, DeploymentState state, PageRequest pageRequest) {
        Page<InternalDeployment> deployments = this.deployedCommitDao.getDeployments(repoIds, commitIds, state, pageRequest);
        BulkCommitsRequest.Builder commitsRequest = new BulkCommitsRequest.Builder().maxMessageLength(0).ignoreMissing(true);
        deployments.stream().forEach(deployment -> {
            deployment.getFromCommitId().ifPresent(fromCommitId -> commitsRequest.commit((Repository)deployment.getRepository(), fromCommitId));
            commitsRequest.commit((Repository)deployment.getRepository(), deployment.getToCommitId());
        });
        HashMap commitMap = new HashMap();
        this.commitService.streamCommits(commitsRequest.build(), (commit, repositories) -> {
            commitMap.put(commit.getId(), commit);
            return true;
        });
        return deployments.transform(deployment -> this.convertToDeployment((InternalDeployment)deployment, commitMap));
    }

    private Optional<InternalDeployment> getInternalDeployment(Repository repository, String key, String environmentKey, long deploymentSequenceNumber) {
        this.validateKeys(key, environmentKey);
        return this.deploymentDao.get(InternalConverter.convertToInternalRepository((Repository)repository), key, environmentKey, deploymentSequenceNumber);
    }

    private Optional<String> getPreviousDeploymentCommitId(InternalRepository repository, String key, String environmentKey, long deploymentSequenceNumber) {
        return this.deploymentDao.getLastSuccessful(repository, key, environmentKey, deploymentSequenceNumber).map(InternalDeployment::getToCommitId);
    }

    private Commit toCommit(InternalRepository repository, String commitId) {
        if (StringUtils.isBlank((CharSequence)commitId)) {
            return null;
        }
        return this.commitService.getCommits(((CommitsRequest.Builder)((CommitsRequest.Builder)new CommitsRequest.Builder((Repository)repository, commitId).maxMessageLength(0)).ignoreMissing(true)).build(), PageUtils.newRequest((int)0, (int)1)).stream().findFirst().orElseGet(() -> {
            log.warn("The previous commit id {}, cannot be resolved in repository {}", (Object)commitId, (Object)repository);
            return null;
        });
    }

    private void validateCommitId(String commitId) {
        if (!ShaUtils.isHash((String)commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.invalid.commit.given", new Object[0]));
        }
    }

    private void validateCommitIdOnDeployment(InternalDeployment internalDeployment, String commitId) {
        if (!internalDeployment.getToCommitId().equals(commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.deployment.commit.id.mismatch", new Object[]{internalDeployment.getToCommitId(), commitId}));
        }
    }

    private void validateKeys(String key, String environmentKey) {
        if (key.length() > 255) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.deployment.key.length.too.long", new Object[0]));
        }
        if (environmentKey.length() > 255) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.environment.key.length.too.long", new Object[0]));
        }
    }

    private void validateUrl(URI url, String field) {
        if (url.toString().length() > 1024) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.url.too.long", new Object[]{field}));
        }
        if (!url.isAbsolute()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.url.not.absolute", new Object[]{field}));
        }
        if (!UrlHrefUtils.isSchemeAllowed((URI)url)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.url.scheme.invalid", new Object[]{field}));
        }
    }
}

