/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.dmz.deployment.DeploymentCommitIndexerModuleDescriptor;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironment;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentCreatedEvent;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentIndexingCompleteEvent;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.internal.deployments.IndexerList;
import com.atlassian.bitbucket.internal.deployments.dao.DeployedCommitDao;
import com.atlassian.bitbucket.internal.deployments.dao.DeploymentDao;
import com.atlassian.bitbucket.internal.deployments.event.AnalyticsDeploymentIndexingFailedEvent;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.concurrent.StateTransferringExecutorService;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@RequireFeature(value=StandardFeature.DEPLOYMENTS)
public class DeploymentCommitIndexingService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentCommitIndexingService.class);
    private final DeployedCommitDao deployedCommitDao;
    private final DeploymentDao deploymentDao;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final Issue indexingFailedIssue;
    private final Duration indexingTimeout;
    private final Issue indexingTruncatedIssue;
    private final int maxCommitMessageSize;
    private final int maxCommitsPerDeployment;
    private final ComponentMonitor monitor;
    private final PluginAccessor pluginAccessor;
    private final ScmService scmService;
    private final TransactionTemplate withNewTransaction;

    public DeploymentCommitIndexingService(DeployedCommitDao deployedCommitDao, DeploymentDao deploymentDao, EventPublisher eventPublisher, ExecutorService executorService, Duration indexingTimeout, MonitoringService monitoringService, int maxCommitsPerDeployment, int maxCommitMessageSize, PluginAccessor pluginAccessor, ScmService scmService, TransferableStateManager stateManager, PlatformTransactionManager transactionManager) {
        this.deployedCommitDao = deployedCommitDao;
        this.deploymentDao = deploymentDao;
        this.eventPublisher = eventPublisher;
        this.executorService = new StateTransferringExecutorService(executorService, stateManager);
        this.indexingTimeout = indexingTimeout;
        this.maxCommitsPerDeployment = maxCommitsPerDeployment;
        this.maxCommitMessageSize = maxCommitMessageSize;
        this.pluginAccessor = pluginAccessor;
        this.scmService = scmService;
        this.monitor = monitoringService.createMonitor("DeploymentCommitIndexer", "bitbucket.deployment.diagnostics.indexing.name");
        this.indexingFailedIssue = this.monitor.defineIssue(2004).severity(Severity.ERROR).summaryI18nKey("bitbucket.deployment.diagnostics.indexing.failed.summary").descriptionI18nKey("bitbucket.deployment.diagnostics.indexing.failed.description").build();
        this.indexingTruncatedIssue = this.monitor.defineIssue(2005).severity(Severity.WARNING).summaryI18nKey("bitbucket.deployment.diagnostics.indexing.truncated.summary").descriptionI18nKey("bitbucket.deployment.diagnostics.indexing.truncated.description").build();
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @EventListener
    public void onDeploymentSet(@Nonnull DeploymentCreatedEvent event) {
        try {
            this.executorService.submit(() -> this.withNewTransaction.execute(status -> {
                this.indexDeploymentCommits(event);
                return null;
            }));
        }
        catch (RejectedExecutionException e) {
            Deployment deployment = event.getDeployment();
            this.monitor.alert(new AlertRequest.Builder(this.indexingFailedIssue).details(() -> this.getAlertDetails(deployment)).build());
            log.info("The deployments indexing executor queue is full and is unable to schedule indexing for deployment ({}, {}, {}) in repository {}.", new Object[]{deployment.getKey(), deployment.getEnvironment().getKey(), deployment.getDeploymentSequenceNumber(), deployment.getRepository()});
            this.eventPublisher.publish((Object)new AnalyticsDeploymentIndexingFailedEvent(this, deployment));
        }
    }

    @EventListener
    public void onRepositoryDeletionRequestedEvent(RepositoryDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.deployedCommitDao.deleteByRepository(event.getRepository());
            this.deploymentDao.deleteByRepository(event.getRepository());
        }
    }

    private ImmutableMap<String, Object> getAlertDetails(Deployment deployment) {
        DeploymentEnvironment environment = deployment.getEnvironment();
        ImmutableMap.Builder environmentDetails = ImmutableMap.builder().put((Object)"key", (Object)environment.getKey()).put((Object)"displayName", (Object)environment.getDisplayName());
        environment.getType().ifPresent(type -> environmentDetails.put((Object)"type", (Object)type.name()));
        environment.getUrl().ifPresent(url -> environmentDetails.put((Object)"url", (Object)url.toASCIIString()));
        ImmutableMap.Builder detailsBuilder = ImmutableMap.builder();
        deployment.getFromCommit().map(MinimalCommit::getId).ifPresent(commitId -> detailsBuilder.put((Object)"fromCommitId", commitId));
        return detailsBuilder.put((Object)"deploymentSequenceNumber", (Object)deployment.getDeploymentSequenceNumber()).put((Object)"description", (Object)deployment.getDescription()).put((Object)"displayName", (Object)deployment.getDisplayName()).put((Object)"environment", (Object)environmentDetails.build()).put((Object)"key", (Object)deployment.getKey()).put((Object)"lastUpdated", (Object)deployment.getLastUpdated()).put((Object)"maxCommitsPerDeployment", (Object)this.maxCommitsPerDeployment).put((Object)"repository", (Object)deployment.getRepository().toString()).put((Object)"state", (Object)deployment.getState()).put((Object)"toCommitId", (Object)deployment.getToCommit().getId()).put((Object)"url", (Object)deployment.getUrl().toASCIIString()).build();
    }

    private void handleCommitsTruncated(boolean truncated, Deployment deployment, InternalRepository repository) {
        if (truncated) {
            log.debug("Reached the limit of commits ({}) that can be part of a deployment. Will not be adding any more commits to deployment ({}, {}, {}) in repository {}.", new Object[]{this.maxCommitsPerDeployment, deployment.getKey(), deployment.getEnvironment(), deployment.getDeploymentSequenceNumber(), repository});
            this.monitor.alert(new AlertRequest.Builder(this.indexingTruncatedIssue).details(() -> this.getAlertDetails(deployment)).build());
        }
    }

    private IndexerList getEnabledIndexers(Deployment deployment) {
        return new IndexerList(ModuleDescriptorUtils.toModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(DeploymentCommitIndexerModuleDescriptor.class)).map(provider -> provider.createIndexer(deployment)).collect(Collectors.toList()));
    }

    private void handleDeploymentNotFound(Deployment deployment, InternalRepository repository) {
        this.monitor.alert(new AlertRequest.Builder(this.indexingFailedIssue).details(() -> this.getAlertDetails(deployment)).build());
        log.info("Could not find deployment ({}, {}, {}) in repository {}. Will not index any commits for this deployment.", new Object[]{deployment.getKey(), deployment.getEnvironment().getKey(), deployment.getDeploymentSequenceNumber(), repository});
        this.eventPublisher.publish((Object)new AnalyticsDeploymentIndexingFailedEvent(this, deployment));
    }

    private List<String> indexCommitsBetween(String toCommitId, String fromCommitId, InternalRepository repository, IndexerList indexers) {
        if (fromCommitId.equals(toCommitId)) {
            return this.indexSingleCommit(toCommitId, repository, indexers);
        }
        return this.streamCommits(toCommitId, fromCommitId, repository, indexers);
    }

    private void indexDeploymentCommits(DeploymentCreatedEvent event) {
        Deployment deployment = event.getDeployment();
        long deploymentSequenceNumber = deployment.getDeploymentSequenceNumber();
        DeploymentEnvironment environment = deployment.getEnvironment();
        String key = deployment.getKey();
        String toCommitId = deployment.getToCommit().getId();
        String fromCommitId = deployment.getFromCommit().map(MinimalCommit::getId).orElse(toCommitId);
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)event.getRepository());
        Optional<InternalDeployment> maybeDeployment = this.deploymentDao.get(repository, key, environment.getKey(), deploymentSequenceNumber);
        if (!maybeDeployment.isPresent()) {
            this.handleDeploymentNotFound(deployment, repository);
            return;
        }
        InternalDeployment internalDeployment = maybeDeployment.get();
        IndexerList indexers = this.getEnabledIndexers(deployment);
        List<String> commitIds = this.indexCommitsBetween(toCommitId, fromCommitId, repository, indexers);
        int count = commitIds.size();
        for (String commitId : commitIds) {
            this.deployedCommitDao.addDeployedCommit(repository, commitId, internalDeployment);
        }
        boolean truncated = count >= this.maxCommitsPerDeployment;
        this.handleCommitsTruncated(truncated, deployment, repository);
        indexers.forEach(indexer -> indexer.onAfterIndexing(truncated));
        this.eventPublisher.publish((Object)new DeploymentIndexingCompleteEvent((Object)this, deployment, count, truncated));
    }

    private List<String> indexSingleCommit(String toCommitId, InternalRepository repository, IndexerList indexers) {
        Commit commit = (Commit)this.scmService.getCommandFactory((Repository)repository).commit(((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().commitId(toCommitId)).maxMessageLength(this.maxCommitMessageSize).build()).call();
        if (commit != null) {
            indexers.forEachEnabled(indexer -> indexer.onCommit(commit));
        }
        return Collections.singletonList(toCommitId);
    }

    private List<String> streamCommits(String toCommitId, String fromCommitId, InternalRepository repository, IndexerList indexers) {
        ArrayList<String> commitIds = new ArrayList<String>(this.maxCommitsPerDeployment);
        AtomicInteger count = new AtomicInteger();
        CommitsCommandParameters request = new CommitsCommandParameters.Builder().include(toCommitId, new String[0]).exclude(fromCommitId, new String[0]).maxMessageLength(this.maxCommitMessageSize).build();
        Command commitsCommand = this.scmService.getCommandFactory((Repository)repository).commits(request, commit -> {
            commitIds.add(commit.getId());
            count.getAndIncrement();
            indexers.forEachEnabled(indexer -> indexer.onCommit(commit));
            return count.get() < this.maxCommitsPerDeployment;
        });
        commitsCommand.setExecutionTimeout(this.indexingTimeout);
        commitsCommand.call();
        return commitIds;
    }
}

