/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments;

import com.atlassian.bitbucket.dmz.deployment.DeploymentCommitIndexer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerList {
    private static final Logger log = LoggerFactory.getLogger(IndexerList.class);
    private final List<DeploymentCommitIndexer> enabledIndexers;
    private final List<DeploymentCommitIndexer> indexers;

    public IndexerList(List<DeploymentCommitIndexer> indexers) {
        this.indexers = indexers;
        this.enabledIndexers = new ArrayList<DeploymentCommitIndexer>(indexers);
    }

    void forEach(Consumer<DeploymentCommitIndexer> effect) {
        this.indexers.forEach(effect);
    }

    void forEachEnabled(Consumer<DeploymentCommitIndexer> effect) {
        Iterator<DeploymentCommitIndexer> it = this.enabledIndexers.iterator();
        while (it.hasNext()) {
            DeploymentCommitIndexer indexer = it.next();
            try {
                effect.accept(indexer);
            }
            catch (Exception e) {
                it.remove();
                log.warn("Deployment commit indexer {} caused an error '{}: {}' and has been disabled for the remainder of this indexing run. Enable debug logging to see the exception details.", new Object[]{indexer.getClass().getName(), e.getClass().getName(), e.getMessage()});
                log.debug("Deployment commit indexer error:", (Throwable)e);
            }
        }
    }
}

