/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments;

import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentType;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.internal.deployments.SimpleDeploymentEnvironment;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.UrlHrefUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class SimpleDeployment
implements Deployment {
    private final long deploymentSequenceNumber;
    private final String description;
    private final String displayName;
    private final DeploymentEnvironment environment;
    private final MinimalCommit fromCommit;
    private final long id;
    private final String key;
    private final Date lastUpdated;
    private final Repository repository;
    private final DeploymentState state;
    private final MinimalCommit toCommit;
    private final URI url;

    private SimpleDeployment(Builder builder) {
        this.id = builder.id;
        this.toCommit = builder.toCommit;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.deploymentSequenceNumber = builder.deploymentSequenceNumber;
        this.key = builder.key;
        this.lastUpdated = builder.lastUpdated;
        this.environment = builder.environment;
        this.fromCommit = builder.fromCommit;
        this.repository = builder.repository;
        this.state = builder.state;
        this.url = UrlHrefUtils.getSanitizedUrl((URI)builder.url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDeployment that = (SimpleDeployment)o;
        return this.deploymentSequenceNumber == that.deploymentSequenceNumber && this.id == that.id && Objects.equals(this.description, that.description) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.environment, that.environment) && Objects.equals(this.fromCommit, that.fromCommit) && Objects.equals(this.key, that.key) && Objects.equals(this.lastUpdated, that.lastUpdated) && Objects.equals(this.repository, that.repository) && this.state == that.state && Objects.equals(this.toCommit, that.toCommit) && Objects.equals(this.url, that.url);
    }

    public long getDeploymentSequenceNumber() {
        return this.deploymentSequenceNumber;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public DeploymentEnvironment getEnvironment() {
        return this.environment;
    }

    @Nonnull
    public Optional<MinimalCommit> getFromCommit() {
        return Optional.ofNullable(this.fromCommit);
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public DeploymentState getState() {
        return this.state;
    }

    @Nonnull
    public MinimalCommit getToCommit() {
        return this.toCommit;
    }

    @Nonnull
    public URI getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hash(this.deploymentSequenceNumber, this.description, this.displayName, this.environment, this.fromCommit, this.key, this.lastUpdated, this.repository, this.state, this.toCommit, this.url);
    }

    public String toString() {
        return "SimpleDeployment{deploymentSequenceNumber=" + this.deploymentSequenceNumber + ", description='" + this.description + "', displayName='" + this.displayName + "', environment=" + String.valueOf(this.environment) + ", fromCommit=" + String.valueOf(this.fromCommit) + ", key='" + this.key + "', lastUpdated=" + String.valueOf(this.lastUpdated) + ", repository=" + String.valueOf(this.repository) + ", state=" + String.valueOf(this.state) + ", toCommit=" + String.valueOf(this.toCommit) + ", url=" + String.valueOf(this.url) + "}";
    }

    public static class Builder
    extends BuilderSupport {
        private final long deploymentSequenceNumber;
        private final String description;
        private final String displayName;
        private final DeploymentEnvironment environment;
        private final long id;
        private final String key;
        private final Date lastUpdated;
        private final Repository repository;
        private final DeploymentState state;
        private final MinimalCommit toCommit;
        private final URI url;
        private MinimalCommit fromCommit;

        public Builder(long deploymentSequenceNumber, @Nonnull String description, @Nonnull String displayName, @Nonnull DeploymentEnvironment environment, long id, @Nonnull String key, @Nonnull Date lastUpdated, @Nonnull Repository repository, @Nonnull DeploymentState state, @Nonnull MinimalCommit toCommit, @Nonnull URI url) {
            this.deploymentSequenceNumber = deploymentSequenceNumber;
            this.description = Builder.requireNonBlank((String)StringUtils.stripToNull((String)description), (String)"description");
            this.displayName = Builder.requireNonBlank((String)StringUtils.stripToNull((String)displayName), (String)"displayName");
            this.environment = Objects.requireNonNull(environment, "environment");
            this.key = Builder.requireNonBlank((String)StringUtils.stripToNull((String)key), (String)"key");
            this.lastUpdated = Objects.requireNonNull(lastUpdated, "date");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.id = id;
            this.state = Objects.requireNonNull(state, "state");
            this.toCommit = Objects.requireNonNull(toCommit, "commit");
            this.url = Objects.requireNonNull(url, "url");
        }

        public Builder(@Nonnull InternalDeployment deployment, @Nonnull MinimalCommit toCommit) {
            this(Objects.requireNonNull(deployment, "deployment").getDeploymentSequenceNumber(), deployment.getDescription(), deployment.getDisplayName(), Builder.getEnvironment(deployment), deployment.getId(), deployment.getKey(), deployment.getLastUpdated(), (Repository)deployment.getRepository(), DeploymentState.fromString((String)deployment.getState()).orElse(DeploymentState.UNKNOWN), toCommit, URI.create(deployment.getUrl()));
        }

        @Nonnull
        public Deployment build() {
            return new SimpleDeployment(this);
        }

        @Nonnull
        public Builder fromCommit(@Nullable MinimalCommit value) {
            this.fromCommit = value;
            return this;
        }

        private static DeploymentEnvironment getEnvironment(InternalDeployment deployment) {
            SimpleDeploymentEnvironment.Builder environmentBuilder = new SimpleDeploymentEnvironment.Builder(deployment.getEnvironmentDisplayName(), deployment.getEnvironmentKey());
            deployment.getEnvironmentType().ifPresent(envType -> environmentBuilder.type(DeploymentEnvironmentType.fromString((String)envType).orElse(null)));
            deployment.getEnvironmentUrl().ifPresent(envUrl -> environmentBuilder.url(URI.create(envUrl)));
            return environmentBuilder.build();
        }
    }
}

