/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments;

import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.UrlHrefUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public final class SimpleDeploymentEnvironment
implements DeploymentEnvironment {
    private final String displayName;
    private final String key;
    private final DeploymentEnvironmentType type;
    private final URI url;

    private SimpleDeploymentEnvironment(Builder builder) {
        this.displayName = builder.displayName;
        this.key = builder.key;
        this.type = builder.type;
        this.url = UrlHrefUtils.getSanitizedUrl((URI)builder.url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDeploymentEnvironment that = (SimpleDeploymentEnvironment)o;
        return this.key.equals(that.key) && this.type == that.type && this.displayName.equals(that.displayName);
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Optional<DeploymentEnvironmentType> getType() {
        return Optional.ofNullable(this.type);
    }

    @Nonnull
    public Optional<URI> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.displayName, this.type);
    }

    public static class Builder
    extends BuilderSupport {
        private final String displayName;
        private final String key;
        private DeploymentEnvironmentType type;
        private URI url;

        public Builder(@Nonnull String displayName, @Nonnull String key) {
            this.displayName = Builder.requireNonBlank((String)displayName, (String)"name");
            this.key = Builder.requireNonBlank((String)key, (String)"id");
        }

        @Nonnull
        public DeploymentEnvironment build() {
            return new SimpleDeploymentEnvironment(this);
        }

        @Nonnull
        public Builder type(@Nullable DeploymentEnvironmentType value) {
            this.type = value;
            return this;
        }

        @Nonnull
        public Builder url(@Nullable URI value) {
            this.url = value;
            return this;
        }
    }
}

