/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments.dao;

import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.internal.deployments.dao.DeployedCommitDao;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployedCommit;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployedCommit_;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment_;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepository_;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.SessionFactory;

public class HibernateDeployedCommitDao
extends AbstractHibernateDao<String, InternalDeployedCommit>
implements DeployedCommitDao {
    private static final Predicate[] PREDICATES = new Predicate[0];
    private final int maxEntityCount;

    public HibernateDeployedCommitDao(SessionFactory sessionFactory, int maxEntityCount) {
        super(sessionFactory);
        this.maxEntityCount = maxEntityCount;
    }

    @Override
    @Nonnull
    public InternalDeployedCommit addDeployedCommit(@Nonnull InternalRepository repository, @Nonnull String commit, @Nonnull InternalDeployment deployment) {
        InternalDeployedCommit mapping = this.getMapping(deployment, commit).orElseGet(() -> this.createMapping(repository, commit, deployment));
        if (this.session().getStatistics().getEntityCount() > this.maxEntityCount) {
            this.session().flush();
            this.session().clear();
        }
        return mapping;
    }

    @Override
    public void deleteByRepository(@Nonnull Repository repository) {
        this.session().createQuery("delete from InternalDeployedCommit where repository.id = :repoId").setParameter("repoId", (Object)repository.getId()).executeUpdate();
    }

    @Override
    @Nonnull
    public Page<InternalDeployment> getDeployments(@Nonnull Collection<Integer> repositoryIds, @Nonnull Collection<String> commitIds, @Nullable DeploymentState state, @Nonnull PageRequest pageRequest) {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(InternalDeployment.class);
        Root deployedCommit = query.from(InternalDeployedCommit.class);
        Join deployments = deployedCommit.join(InternalDeployedCommit_.deployment);
        ImmutableList.Builder ands = ImmutableList.builder();
        if (!repositoryIds.isEmpty()) {
            Predicate matchesRepository = deployedCommit.get(InternalDeployedCommit_.repository).get(InternalRepository_.id).in(repositoryIds);
            ands.add((Object)matchesRepository);
        }
        if (!commitIds.isEmpty()) {
            Predicate matchesCommits = deployedCommit.get(InternalDeployedCommit_.commit).in(commitIds);
            ands.add((Object)matchesCommits);
        }
        if (state != null) {
            Predicate matchesState = criteriaBuilder.equal((Expression)deployedCommit.get(InternalDeployedCommit_.deployment).get(InternalDeployment_.state), (Object)state.name().toUpperCase(Locale.US));
            ands.add((Object)matchesState);
        }
        CriteriaQuery criteria = query.select((Selection)deployments).distinct(true).where((Expression)criteriaBuilder.and((Predicate[])ands.build().toArray((Object[])PREDICATES))).orderBy(new Order[]{criteriaBuilder.desc((Expression)deployments.get(InternalDeployment_.lastUpdated))});
        return HibernateUtils.initializePage((Page)this.pageQuery(this.session().createQuery(criteria), pageRequest));
    }

    private InternalDeployedCommit createMapping(InternalRepository repository, String commit, InternalDeployment deployment) {
        return (InternalDeployedCommit)HibernateUtils.initialize((Object)((InternalDeployedCommit)this.create(new InternalDeployedCommit(repository, commit, deployment))));
    }

    private Optional<InternalDeployedCommit> getMapping(InternalDeployment deployment, String commit) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalDeployedCommit.class);
        Root root = criteria.from(InternalDeployedCommit.class);
        criteria.select((Selection)root).where(new Predicate[]{builder.equal((Expression)root.get(InternalDeployedCommit_.commit), (Object)commit), builder.equal((Expression)root.get(InternalDeployedCommit_.deployment).get(InternalDeployment_.id), (Object)deployment.getId())});
        return this.session().createQuery(criteria).uniqueResultOptional().map(HibernateUtils::initialize);
    }
}

