/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments.dao;

import com.atlassian.bitbucket.dmz.deployments.DeploymentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.internal.deployments.dao.DeploymentDao;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment;
import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment_;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepository_;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Optional;
import org.hibernate.SessionFactory;

public class HibernateDeploymentDao
extends AbstractHibernateDao<Long, InternalDeployment>
implements DeploymentDao {
    public HibernateDeploymentDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void deleteByRepository(Repository repository) {
        this.session().createQuery("delete from InternalDeployment where repository.id = :repoId").setParameter("repoId", (Object)repository.getId()).executeUpdate();
    }

    @Override
    @Nonnull
    public Optional<InternalDeployment> get(InternalRepository repository, String key, String environmentKey, long deploymentSequenceNumber) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalDeployment.class);
        Root root = criteria.from(InternalDeployment.class);
        criteria.select((Selection)root).where((Expression)builder.and(new Predicate[]{builder.equal((Expression)root.get(InternalDeployment_.repository).get(InternalRepository_.id), (Object)repository.getId()), builder.equal((Expression)root.get(InternalDeployment_.key), (Object)key), builder.equal((Expression)root.get(InternalDeployment_.environmentKey), (Object)environmentKey), builder.equal((Expression)root.get(InternalDeployment_.deploymentSequenceNumber), (Object)deploymentSequenceNumber)}));
        return this.session().createQuery(criteria).setMaxResults(1).uniqueResultOptional().map(HibernateUtils::initialize);
    }

    @Override
    @Nonnull
    public Optional<InternalDeployment> getLastSuccessful(@Nonnull InternalRepository repository, @Nonnull String key, @Nonnull String environmentKey, long maxDeploymentSequenceNumber) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalDeployment.class);
        Root root = criteria.from(InternalDeployment.class);
        criteria.select((Selection)root).where((Expression)builder.and(new Predicate[]{builder.equal((Expression)root.get(InternalDeployment_.repository).get(InternalRepository_.id), (Object)repository.getId()), builder.equal((Expression)root.get(InternalDeployment_.key), (Object)key), builder.equal((Expression)root.get(InternalDeployment_.environmentKey), (Object)environmentKey), builder.lessThan((Expression)root.get(InternalDeployment_.deploymentSequenceNumber), (Comparable)Long.valueOf(maxDeploymentSequenceNumber)), builder.equal((Expression)root.get(InternalDeployment_.state), (Object)DeploymentState.SUCCESSFUL.name())})).orderBy(new Order[]{builder.desc((Expression)root.get(InternalDeployment_.deploymentSequenceNumber))});
        return this.session().createQuery(criteria).setMaxResults(1).uniqueResultOptional().map(HibernateUtils::initialize);
    }

    @Override
    public InternalDeployment set(@Nonnull DeploymentSetRequest request, @Nullable String fromCommitId, @Nullable Long id) {
        InternalDeployment deployment = new InternalDeployment.Builder(request).fromCommitId(fromCommitId).id(id).build();
        return (InternalDeployment)HibernateUtils.initialize((Object)((InternalDeployment)this.update(deployment)));
    }
}

