/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments.event;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentCreatedEvent;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentDeletedEvent;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentEvent;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentUpdatedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class AuditingDeploymentEventListener {
    @VisibleForTesting
    static final String ACTION_DEPLOYMENT_CREATED = "bitbucket.deployment.audit.action.created";
    @VisibleForTesting
    static final String ACTION_DEPLOYMENT_DELETED = "bitbucket.deployment.audit.action.deleted";
    @VisibleForTesting
    static final String ACTION_DEPLOYMENT_UPDATED = "bitbucket.deployment.audit.action.updated";
    @VisibleForTesting
    static final String ATTR_DEPLOYMENT_SEQUENCE_NUMBER = "bitbucket.deployment.audit.attribute.sequenceNumber";
    @VisibleForTesting
    static final String ATTR_ENVIRONMENT_KEY = "bitbucket.deployment.audit.attribute.environment.key";
    @VisibleForTesting
    static final String ATTR_FROM_COMMIT_ID = "bitbucket.deployment.audit.attribute.fromcommitid";
    @VisibleForTesting
    static final String ATTR_KEY = "bitbucket.deployment.audit.attribute.deployment.key";
    @VisibleForTesting
    static final String ATTR_TO_COMMIT_ID = "bitbucket.deployment.audit.attribute.tocommitid";
    private final AuditService auditService;

    public AuditingDeploymentEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onDeploymentCreatedEvent(DeploymentCreatedEvent event) {
        this.auditDeploymentEvent((DeploymentEvent)event, ACTION_DEPLOYMENT_CREATED);
    }

    @EventListener
    public void onDeploymentDeletedEvent(DeploymentDeletedEvent event) {
        this.auditDeploymentEvent((DeploymentEvent)event, ACTION_DEPLOYMENT_DELETED);
    }

    @EventListener
    public void onDeploymentUpdatedEvent(DeploymentUpdatedEvent event) {
        this.auditDeploymentEvent((DeploymentEvent)event, ACTION_DEPLOYMENT_UPDATED);
    }

    private void auditDeploymentEvent(DeploymentEvent event, String action) {
        Deployment deployment = event.getDeployment();
        ImmutableList.Builder extraAttributes = ImmutableList.builder().add((Object)AuditAttribute.fromI18nKeys((String)ATTR_DEPLOYMENT_SEQUENCE_NUMBER, (String)String.valueOf(deployment.getDeploymentSequenceNumber())).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_ENVIRONMENT_KEY, (String)deployment.getEnvironment().getKey()).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_KEY, (String)deployment.getKey()).build()).add((Object)AuditAttribute.fromI18nKeys((String)ATTR_TO_COMMIT_ID, (String)deployment.getToCommit().getId()).build());
        event.getDeployment().getFromCommit().ifPresent(fromCommit -> extraAttributes.add((Object)AuditAttribute.fromI18nKeys((String)ATTR_FROM_COMMIT_ID, (String)fromCommit.getId()).build()));
        AuditEvent auditEvent = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)action).build()).affectedObject(AuditUtils.auditResourceForRepository((Repository)event.getRepository())).extraAttributes((Collection)extraAttributes.build()).build();
        this.auditService.audit(auditEvent);
    }
}

