/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments.model;

import com.atlassian.bitbucket.internal.deployments.model.InternalDeployment;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Cacheable
@Entity
@Table(name="bb_dep_commit", indexes={@Index(name="idx_bb_dep_commit_repo_commit", columnList="repository_id,commit_id"), @Index(name="idx_bb_dep_commit_dep_id", columnList="deployment_id")})
@TableGenerator(allocationSize=20, pkColumnValue="bb_dep_commit", name="deployedCommitMappingGenerator", table="id_sequence")
public class InternalDeployedCommit
implements Initializable {
    public static final String ID_GEN = "deployedCommitMappingGenerator";
    public static final String TABLE = "bb_dep_commit";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="deployedCommitMappingGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @JoinColumn(name="repository_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_dep_commit_repository"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @Column(name="commit_id", nullable=false)
    private String commit;
    @JoinColumn(name="deployment_id", foreignKey=@ForeignKey(name="fk_bb_dep_commit_dep"), nullable=false, updatable=false)
    @ManyToOne
    private InternalDeployment deployment;

    public InternalDeployedCommit(@Nonnull InternalRepository repository, @Nonnull String commit, @Nonnull InternalDeployment deployment) {
        this.commit = Objects.requireNonNull(commit, "commit");
        this.deployment = Objects.requireNonNull(deployment, "deployment");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.id = 0L;
    }

    protected InternalDeployedCommit() {
        this.id = 0L;
    }

    @Nonnull
    public String getCommit() {
        return this.commit;
    }

    @Nonnull
    public InternalDeployment getDeployment() {
        return this.deployment;
    }

    public void initialize() {
        HibernateUtils.initialize((Object)this.getDeployment());
    }
}

