/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.deployments.model;

import com.atlassian.bitbucket.dmz.deployments.DeploymentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Entity
@Table(name="bb_deployment", indexes={@Index(name="idx_bb_dep_identifiers", columnList="repository_id,deployment_key,environment_key,deployment_sequence_number"), @Index(name="idx_bb_dep_repo_commit", columnList="repository_id,to_commit_id")})
@TableGenerator(allocationSize=10, pkColumnValue="bb_deployment", name="deploymentIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalDeployment
implements Initializable {
    public static final String ID_GEN = "deploymentIdGenerator";
    public static final String TABLE = "bb_deployment";
    @Column(name="deployment_sequence_number", nullable=false)
    private long deploymentSequenceNumber;
    @Column(name="description", nullable=false)
    private String description;
    @Column(name="display_name", nullable=false)
    private String displayName;
    @Column(name="environment_display_name", nullable=false)
    private String environmentDisplayName;
    @Column(name="environment_key", nullable=false)
    private String environmentKey;
    @Column(name="environment_type")
    private String environmentType;
    @Column(name="environment_url")
    private String environmentUrl;
    @Column(name="from_commit_id")
    private String fromCommitId;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="deploymentIdGenerator", strategy=GenerationType.TABLE)
    private long id;
    @Column(name="deployment_key", nullable=false)
    private String key;
    @Column(name="last_updated", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdated;
    @JoinColumn(name="repository_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_deployment_repository"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @Column(name="state", nullable=false)
    private String state;
    @Column(name="to_commit_id", nullable=false)
    private String toCommitId;
    @Column(name="url", nullable=false)
    private String url;

    protected InternalDeployment() {
    }

    private InternalDeployment(Builder builder) {
        this.deploymentSequenceNumber = builder.deploymentSequenceNumber;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.environmentKey = builder.environmentKey;
        this.environmentDisplayName = builder.environmentDisplayName;
        this.environmentType = builder.environmentType;
        this.environmentUrl = builder.environmentUrl;
        this.fromCommitId = builder.fromCommitId;
        this.id = builder.id == null ? 0L : builder.id;
        this.key = builder.key;
        this.lastUpdated = builder.lastUpdated;
        this.repository = builder.repository;
        this.state = builder.state.name().toUpperCase(Locale.US);
        this.toCommitId = builder.toCommitId;
        this.url = builder.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalDeployment that = (InternalDeployment)o;
        return this.deploymentSequenceNumber == that.deploymentSequenceNumber && this.id == that.id && Objects.equals(this.description, that.description) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.environmentDisplayName, that.environmentDisplayName) && Objects.equals(this.environmentKey, that.environmentKey) && Objects.equals(this.environmentType, that.environmentType) && Objects.equals(this.environmentUrl, that.environmentUrl) && Objects.equals(this.fromCommitId, that.fromCommitId) && Objects.equals(this.key, that.key) && Objects.equals(this.lastUpdated, that.lastUpdated) && Objects.equals(this.repository, that.repository) && Objects.equals(this.state, that.state) && Objects.equals(this.toCommitId, that.toCommitId) && Objects.equals(this.url, that.url);
    }

    public long getDeploymentSequenceNumber() {
        return this.deploymentSequenceNumber;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public String getEnvironmentDisplayName() {
        return this.environmentDisplayName;
    }

    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Nonnull
    public Optional<String> getEnvironmentType() {
        return Optional.ofNullable(this.environmentType);
    }

    @Nonnull
    public Optional<String> getEnvironmentUrl() {
        return Optional.ofNullable(this.environmentUrl);
    }

    @Nonnull
    public Optional<String> getFromCommitId() {
        return Optional.ofNullable(this.fromCommitId);
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getState() {
        return this.state;
    }

    @Nonnull
    public String getToCommitId() {
        return this.toCommitId;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hash(this.deploymentSequenceNumber, this.description, this.displayName, this.environmentDisplayName, this.environmentKey, this.environmentType, this.environmentUrl, this.fromCommitId, this.id, this.key, this.lastUpdated, this.repository, this.state, this.toCommitId, this.url);
    }

    public void initialize() {
        HibernateUtils.initialize((Object)this.getRepository());
    }

    public String toString() {
        return "InternalDeployment{deploymentSequenceNumber=" + this.deploymentSequenceNumber + ", description='" + this.description + "', displayName='" + this.displayName + "', environmentDisplayName='" + this.environmentDisplayName + "', environmentKey='" + this.environmentKey + "', environmentType='" + this.environmentType + "', environmentUrl='" + this.environmentUrl + "', fromCommitId='" + this.fromCommitId + "', id=" + this.id + ", key='" + this.key + "', lastUpdated=" + String.valueOf(this.lastUpdated) + ", repository=" + String.valueOf(this.repository) + ", state='" + this.state + "', toCommitId='" + this.toCommitId + "', url='" + this.url + "'}";
    }

    public static class Builder {
        private final long deploymentSequenceNumber;
        private final String description;
        private final String displayName;
        private final String environmentDisplayName;
        private final String environmentKey;
        private final String key;
        private final Date lastUpdated;
        private final InternalRepository repository;
        private final DeploymentState state;
        private final String toCommitId;
        private final String url;
        private String environmentType;
        private String environmentUrl;
        private String fromCommitId;
        private Long id;

        public Builder(long deploymentSequenceNumber, @Nonnull String description, @Nonnull String displayName, @Nonnull String environmentDisplayName, @Nonnull String environmentKey, @Nonnull String key, @Nonnull Date lastUpdated, @Nonnull InternalRepository repository, @Nonnull DeploymentState state, @Nonnull String toCommitId, @Nonnull String url) {
            this.deploymentSequenceNumber = deploymentSequenceNumber;
            this.description = Objects.requireNonNull(description, "description");
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.environmentDisplayName = Objects.requireNonNull(environmentDisplayName, "environmentDisplayName");
            this.environmentKey = Objects.requireNonNull(environmentKey, "environmentKey");
            this.key = Objects.requireNonNull(key, "key");
            this.lastUpdated = Objects.requireNonNull(lastUpdated, "date");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.state = Objects.requireNonNull(state, "state");
            this.toCommitId = Objects.requireNonNull(toCommitId, "toCommitId");
            this.url = Objects.requireNonNull(url, "deploymentUrl");
        }

        public Builder(@Nonnull DeploymentSetRequest request) {
            this(Objects.requireNonNull(request, "request").getDeploymentSequenceNumber(), request.getDescription(), request.getDisplayName(), request.getEnvironmentRequest().getDisplayName(), request.getEnvironmentRequest().getKey(), request.getKey(), request.getLastUpdated(), InternalConverter.convertToInternalRepository((Repository)request.getRepository()), request.getState(), Objects.requireNonNull(request, "request").getCommitId(), request.getUrl().toString());
            request.getEnvironmentRequest().getType().ifPresent(type -> this.environmentType(type.name().toUpperCase(Locale.US)));
            request.getEnvironmentRequest().getUrl().ifPresent(url -> this.environmentUrl(url.toASCIIString()));
        }

        @Nonnull
        public InternalDeployment build() {
            return new InternalDeployment(this);
        }

        @Nonnull
        public Builder environmentType(@Nullable String value) {
            this.environmentType = value;
            return this;
        }

        @Nonnull
        public Builder environmentUrl(@Nullable String value) {
            this.environmentUrl = StringUtils.stripToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder fromCommitId(@Nullable String value) {
            this.fromCommitId = StringUtils.stripToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder id(@Nullable Long value) {
            this.id = value;
            return this;
        }
    }
}

