/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.deployments;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.dmz.deployments.DeploymentService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.deployments.DefaultDeploymentService;
import com.atlassian.bitbucket.internal.deployments.DeploymentCommitIndexingService;
import com.atlassian.bitbucket.internal.deployments.dao.DeployedCommitDao;
import com.atlassian.bitbucket.internal.deployments.dao.DeploymentDao;
import com.atlassian.bitbucket.internal.deployments.dao.HibernateDeployedCommitDao;
import com.atlassian.bitbucket.internal.deployments.dao.HibernateDeploymentDao;
import com.atlassian.bitbucket.internal.deployments.event.AuditingDeploymentEventListener;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import io.atlassian.util.concurrent.ThreadFactories;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class DeploymentsWiring {
    @Bean
    DeployedCommitDao deployedCommitDao(SessionFactory sessionFactory, @Value(value="${hibernate.jdbc.batch_size}") int batchSize) {
        return new HibernateDeployedCommitDao(sessionFactory, batchSize);
    }

    @Bean
    DeploymentCommitIndexingService deploymentCommitIndexer(DeployedCommitDao commitMappingDao, DeploymentDao deploymentDao, EventPublisher eventPublisher, @Qualifier(value="deploymentIndexingExecutor") ExecutorService executorService, @DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${deployments.indexing.timeout}") Duration indexingTimeout, MonitoringService monitoringService, @Value(value="${deployments.commits.max:10000}") int maxCommitsPerDeployment, @Value(value="${commit.message.bulk.max:16384}") int maxCommitMessageSize, PluginAccessor pluginAccessor, ScmService scmService, TransferableStateManager stateManager, PlatformTransactionManager transactionManager) {
        return new DeploymentCommitIndexingService(commitMappingDao, deploymentDao, eventPublisher, executorService, indexingTimeout, monitoringService, maxCommitsPerDeployment, maxCommitMessageSize, pluginAccessor, scmService, stateManager, transactionManager);
    }

    @Bean
    DeploymentDao deploymentDao(SessionFactory sessionFactory) {
        return new HibernateDeploymentDao(sessionFactory);
    }

    @Bean
    AuditingDeploymentEventListener deploymentEventListener(AuditService auditService) {
        return new AuditingDeploymentEventListener(auditService);
    }

    @Bean
    ThreadPoolExecutor deploymentIndexingExecutor(@Value(value="${deployments.indexing.threads.max}") String maxPoolSize) {
        return new ThreadPoolExecutor(0, ExpressionUtils.parseExpressionAsInt((String)maxPoolSize).orElse(4), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"deployments-indexing"));
    }

    @AvailableToPlugins(value=DeploymentService.class)
    @Bean
    DeploymentService deploymentService(CommitService commitService, DeployedCommitDao commitMappingDao, DeploymentDao deploymentDao, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PermissionService permissionService, PullRequestService pullRequestService, PlatformTransactionManager platformTransactionManager) {
        return new DefaultDeploymentService(commitService, commitMappingDao, deploymentDao, eventPublisher, i18nService, permissionValidationService, permissionService, pullRequestService, platformTransactionManager);
    }
}

