/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.filter;

import com.atlassian.crowd.embedded.api.OAuth2Method;
import com.atlassian.crowd.embedded.api.authentication.AuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthService;
import com.atlassian.crowd.model.service.ServiceAccountAuthMethodImpl;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import java.io.IOException;

public class ServiceAccountAuthContextInjectorFilter
extends HttpFilter {
    private final ServiceAccountAuthService authService;

    public ServiceAccountAuthContextInjectorFilter(ServiceAccountAuthService authService) {
        this.authService = authService;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.enrichRequestWithServiceAccount(req);
        super.doFilter(req, res, chain);
    }

    private void enrichRequestWithServiceAccount(ServletRequest req) {
        String clientConfigurationId = (String)req.getAttribute("oauth2.token.client_configuration_id");
        if (clientConfigurationId != null) {
            this.authService.findByAuthMethod((ServiceAccountAuthMethod)new ServiceAccountAuthMethodImpl(clientConfigurationId, (AuthMethod)new OAuth2Method())).ifPresent(serviceAccount -> req.setAttribute("serviceAccount", serviceAccount));
        }
    }
}

