/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application.resilience;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.resilience.Operation;
import com.atlassian.crowd.manager.application.resilience.ResilienceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWithBackoffResilienceStrategy<T>
implements ResilienceStrategy<T> {
    private static final Logger logger = LoggerFactory.getLogger(RetryWithBackoffResilienceStrategy.class);
    public int maxRetries;
    public int maxBackoffMillis;
    public int minBackoffMillis;

    public RetryWithBackoffResilienceStrategy(int maxRetries, int minBackoffMillis, int maxBackoffMillis) {
        this.maxRetries = maxRetries;
        this.minBackoffMillis = Math.max(0, minBackoffMillis);
        this.maxBackoffMillis = Math.max(0, maxBackoffMillis);
    }

    void exponentialBackoff(int retryCount) {
        if (retryCount == 0) {
            return;
        }
        try {
            long wait = Math.min(this.maxBackoffMillis, retryCount * retryCount * this.minBackoffMillis);
            logger.trace("Waiting for {} milliseconds before retrying.", (Object)wait);
            Thread.sleep(wait);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public T execute(Operation<T> operation) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, DirectoryNotFoundException, UserNotFoundException {
        int count = 0;
        while (true) {
            try {
                this.exponentialBackoff(count);
                return operation.execute();
            }
            catch (OperationFailedException e) {
                if (++count <= this.maxRetries) continue;
                throw e;
            }
            break;
        }
    }
}

