/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.manager.cache.EhcacheBackedCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;

public class CacheFactoryEhcache
implements CacheFactory,
CacheManager {
    private final javax.cache.CacheManager cacheManager;

    public CacheFactoryEhcache(javax.cache.CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name) {
        javax.cache.Cache ehcache = this.cacheManager.getCache(name);
        if (ehcache == null) {
            ehcache = this.cacheManager.createCache(name, (Configuration)new MutableConfiguration());
        }
        return new EhcacheBackedCache(ehcache);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull Class<?> owningClass, @Nonnull String name) {
        return this.getCache(owningClass.getName() + "/" + name);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nullable CacheLoader<K, V> loader) {
        javax.cache.Cache ehcache = this.cacheManager.getCache(name);
        if (ehcache == null) {
            ehcache = this.cacheManager.createCache(name, (Configuration)new MutableConfiguration());
        }
        return new EhcacheBackedCache<K, V>(ehcache, loader);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nullable CacheLoader<K, V> loader, @Nonnull CacheSettings required) {
        if (loader == null) {
            return this.getCache(name);
        }
        return this.getCache(name, loader);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        return this.getCache(name);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings required) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings required) {
        throw new UnsupportedOperationException();
    }

    public void flushCaches() {
        this.cacheManager.getCacheNames().forEach(cacheName -> {
            javax.cache.Cache cache = this.cacheManager.getCache(cacheName);
            cache.clear();
        });
    }

    @Nonnull
    public Collection<Cache<?, ?>> getCaches() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ManagedCache getManagedCache(@Nonnull String name) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        this.cacheManager.close();
    }
}

