/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.service;

import com.atlassian.crowd.dao.service.ServiceAccountManagerDAO;
import com.atlassian.crowd.embedded.api.OAuth2Method;
import com.atlassian.crowd.embedded.api.authentication.AuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthService;
import com.atlassian.crowd.manager.service.ServiceAccountMapper;
import com.atlassian.crowd.model.service.InternalServiceAccount;
import com.atlassian.crowd.model.service.InternalServiceAccountAuthMethod;
import com.atlassian.crowd.model.service.ServiceAccountAuthMethodImpl;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ServiceAccountAuthServiceImpl
implements ServiceAccountAuthService {
    public static final String OAUTH2_TYPE_IDENTIFIER = "OAuth2";
    private final ServiceAccountManagerDAO accountManagerDAO;
    private static final Logger log = LoggerFactory.getLogger(ServiceAccountAuthServiceImpl.class);

    public ServiceAccountAuthServiceImpl(ServiceAccountManagerDAO accountManagerDAO) {
        this.accountManagerDAO = accountManagerDAO;
    }

    public Collection<ServiceAccountAuthMethod> getAuthMethods(long serviceAccountId) {
        return this.accountManagerDAO.findAuthMethods(serviceAccountId).stream().map(this::toServiceAccountAuthMethod).toList();
    }

    private ServiceAccountAuthMethod toServiceAccountAuthMethod(InternalServiceAccountAuthMethod method) {
        return this.toAuthMethod(method.getAuthType()).map(authType -> new ServiceAccountAuthMethodImpl(method.getAuthId(), (AuthMethod)authType)).orElse(null);
    }

    public void updateAuth(ServiceAccount serviceAccount, ServiceAccountAuthMethod auth) {
        this.accountManagerDAO.getServiceAccount(serviceAccount.getId()).map(account -> {
            InternalServiceAccountAuthMethod authMethod = new InternalServiceAccountAuthMethod(account, auth.getAuthId(), this.getAuthTypeDBIdentifierOrThrow(auth.getAuthType()));
            Set authMethods = Optional.ofNullable(account.getAuthMethods()).orElseGet(HashSet::new);
            authMethods.clear();
            authMethods.add(authMethod);
            account.setAuthMethods(authMethods);
            this.accountManagerDAO.updateServiceAccount(account);
            return account;
        }).orElseThrow(() -> new IllegalArgumentException("Service account not found with ID: " + serviceAccount.getId()));
    }

    public void deleteAuth(ServiceAccount serviceAccount, ServiceAccountAuthMethod auth) {
        this.accountManagerDAO.deleteAuth(serviceAccount, auth.getAuthId(), this.getAuthTypeDBIdentifierOrThrow(auth.getAuthType()));
    }

    public Optional<ServiceAccount> findByAuthMethod(ServiceAccountAuthMethod auth) {
        return this.getAuthTypeDBIdentifier(auth.getAuthType()).flatMap(authType -> this.accountManagerDAO.findServiceAccountByAuthMethod(auth.getAuthId(), authType)).map(ServiceAccountMapper::toServiceAccount);
    }

    @Nonnull
    public Map<String, ServiceAccount> findByAuthMethods(@Nullable Set<ServiceAccountAuthMethod> authMethods) {
        if (authMethods == null || authMethods.isEmpty()) {
            return Map.of();
        }
        Map<String, String> authIdToTypeMap = authMethods.stream().filter(auth -> auth.getAuthType() instanceof OAuth2Method).collect(Collectors.toMap(ServiceAccountAuthMethod::getAuthId, auth -> OAUTH2_TYPE_IDENTIFIER));
        if (authIdToTypeMap.isEmpty()) {
            return Map.of();
        }
        Map accounts = this.accountManagerDAO.findServiceAccountsByAuthMethods(authIdToTypeMap);
        return accounts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, serviceAccountEntry -> ServiceAccountMapper.toServiceAccount((InternalServiceAccount)serviceAccountEntry.getValue())));
    }

    private String getAuthTypeDBIdentifierOrThrow(AuthMethod authMethod) {
        return this.getAuthTypeDBIdentifier(authMethod).orElseThrow(() -> new IllegalArgumentException("Unsupported auth method type"));
    }

    private Optional<String> getAuthTypeDBIdentifier(AuthMethod authMethod) {
        AuthMethod authMethod2 = authMethod;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OAuth2Method.class}, (Object)authMethod2, n)) {
            case 0 -> {
                OAuth2Method oauth2 = (OAuth2Method)authMethod2;
                yield Optional.of(OAUTH2_TYPE_IDENTIFIER);
            }
            default -> {
                log.debug("Unsupported authType: {}", (Object)authMethod);
                yield Optional.empty();
            }
        };
    }

    private Optional<AuthMethod> toAuthMethod(String authType) {
        String string = authType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OAUTH2_TYPE_IDENTIFIER}, (Object)string, n)) {
            case 0 -> Optional.of(new OAuth2Method());
            default -> {
                log.debug("Unsupported authType: {}", (Object)authType);
                yield Optional.empty();
            }
        };
    }
}

