/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.service;

import com.atlassian.crowd.dao.service.ServiceAccountManagerDAO;
import com.atlassian.crowd.embedded.api.Page;
import com.atlassian.crowd.embedded.api.PageRequest;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.embedded.api.service.ServiceAccountManager;
import com.atlassian.crowd.embedded.api.service.ServiceAccountQuery;
import com.atlassian.crowd.manager.service.ServiceAccountMapper;
import com.atlassian.crowd.model.service.InternalServiceAccount;
import com.atlassian.crowd.search.PageImpl;
import com.atlassian.crowd.util.ResourceRestrictionSetTransformer;
import com.atlassian.crowd.util.ServiceAccountDAOMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ServiceAccountManagerImpl
implements ServiceAccountManager {
    private final ServiceAccountManagerDAO serviceAccountManagerDAO;

    public ServiceAccountManagerImpl(ServiceAccountManagerDAO serviceAccountManagerDAO) {
        this.serviceAccountManagerDAO = serviceAccountManagerDAO;
    }

    public ServiceAccount createServiceAccount(ServiceAccount serviceAccount) {
        InternalServiceAccount internalServiceAccount = this.serviceAccountManagerDAO.createServiceAccount(ServiceAccountDAOMapper.toServiceAccountDAOInput((ServiceAccount)serviceAccount));
        if (serviceAccount.getResourceRestrictions() != null) {
            Set resourceRestrictions = ResourceRestrictionSetTransformer.fromMap((Map)serviceAccount.getResourceRestrictions(), (InternalServiceAccount)internalServiceAccount);
            internalServiceAccount.setResourceRestrictions(resourceRestrictions);
            this.serviceAccountManagerDAO.updateServiceAccount(internalServiceAccount);
        }
        return ServiceAccountMapper.toServiceAccount(internalServiceAccount);
    }

    public Optional<ServiceAccount> getServiceAccount(long id) {
        return this.serviceAccountManagerDAO.getServiceAccount(Long.valueOf(id)).map(ServiceAccountMapper::toServiceAccount);
    }

    public Optional<ServiceAccount> getServiceAccountByName(String name) {
        return this.serviceAccountManagerDAO.getServiceAccountByName(name).map(ServiceAccountMapper::toServiceAccount);
    }

    public boolean updateServiceAccount(ServiceAccount serviceAccount) {
        return this.serviceAccountManagerDAO.updateServiceAccount(ServiceAccountDAOMapper.toServiceAccountDAO((ServiceAccount)serviceAccount));
    }

    public boolean deleteServiceAccount(long id) {
        return this.serviceAccountManagerDAO.deleteServiceAccount(Long.valueOf(id));
    }

    public Page<ServiceAccount> findServiceAccounts(ServiceAccountQuery query, PageRequest request) {
        Page page = this.serviceAccountManagerDAO.findServiceAccounts(query, request);
        List list = page.results().stream().map(ServiceAccountMapper::toServiceAccount).collect(Collectors.toList());
        return new PageImpl<ServiceAccount>(list, page.start(), page.limit(), page.size(), page.isLastPage());
    }

    public boolean archiveServiceAccount(long id) {
        return this.serviceAccountManagerDAO.getServiceAccount(Long.valueOf(id)).map(account -> {
            account.setActive(false);
            return this.serviceAccountManagerDAO.updateServiceAccount(account);
        }).orElse(false);
    }
}

