/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.service;

import com.atlassian.crowd.embedded.api.service.Resource;
import com.atlassian.crowd.embedded.api.service.ResourceType;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.manager.service.ResourceImpl;
import com.atlassian.crowd.manager.service.ResourceTypeImpl;
import com.atlassian.crowd.model.service.InternalServiceAccount;
import com.atlassian.crowd.model.service.ServiceAccountImpl;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ServiceAccountMapper {
    public static ServiceAccount toServiceAccount(InternalServiceAccount internalServiceAccount) {
        Map<ResourceType, Set<Resource>> resourceRestrictions = internalServiceAccount.getResourceRestrictions().stream().map(entry -> {
            String resourceId = entry.getKey();
            String typeId = entry.getValue();
            ResourceImpl resource = new ResourceImpl(resourceId, typeId);
            ResourceTypeImpl resourceType = new ResourceTypeImpl(typeId);
            return Map.entry(resource, resourceType);
        }).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        return ServiceAccountImpl.builder(internalServiceAccount.getName()).id(internalServiceAccount.getId()).active(internalServiceAccount.isActive()).displayName(internalServiceAccount.getDisplayName()).description(internalServiceAccount.getDescription()).resourceRestrictions(resourceRestrictions).build();
    }

    public static ServiceAccountImpl.Builder toServiceAccountBuilder(ServiceAccount existingAccount) {
        return new ServiceAccountImpl.Builder(existingAccount.getName()).id(existingAccount.getId()).displayName(existingAccount.getDisplayName()).description(existingAccount.getDescription()).resourceRestrictions(existingAccount.getResourceRestrictions()).active(existingAccount.isActive());
    }
}

