/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.service;

import com.atlassian.crowd.embedded.api.service.Resource;
import com.atlassian.crowd.embedded.api.service.ResourceType;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class ServiceAccountImpl
implements ServiceAccount,
Serializable {
    private final Long id;
    private final boolean active;
    private final String name;
    private final String displayName;
    private final String description;
    private final Map<ResourceType, Set<Resource>> resourceRestrictions;

    private ServiceAccountImpl(Long id, boolean active, String name, String displayName, String description, Map<ResourceType, Set<Resource>> resourceRestrictions) {
        this.id = id;
        this.active = active;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.resourceRestrictions = resourceRestrictions;
    }

    public Long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<ResourceType, Set<Resource>> getResourceRestrictions() {
        return this.resourceRestrictions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private Long id;
        private boolean active;
        private String name;
        private String displayName;
        private String description;
        private Map<ResourceType, Set<Resource>> resourceRestrictions;

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder resourceRestrictions(Map<ResourceType, Set<Resource>> resourceRestrictions) {
            this.resourceRestrictions = resourceRestrictions;
            return this;
        }

        public ServiceAccountImpl build() {
            return new ServiceAccountImpl(this.id, this.active, this.name, this.displayName, this.description, this.resourceRestrictions);
        }
    }
}

