/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.crowd.sso;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.service.client.ClientProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SsoConfiguration {
    private final CrowdHttpAuthenticator authenticator;
    private final ClientProperties clientProperties;
    private final String cookieDomain;
    private final boolean cookieSecure;
    private final Directory ssoDirectory;

    public SsoConfiguration(CrowdHttpAuthenticator authenticator, String cookieDomain, Directory ssoDirectory, ClientProperties clientProperties, boolean cookieSecure) {
        this.authenticator = authenticator;
        this.cookieDomain = StringUtils.defaultString((String)cookieDomain);
        this.ssoDirectory = ssoDirectory;
        this.clientProperties = clientProperties;
        this.cookieSecure = cookieSecure;
    }

    @Nullable
    public CrowdHttpAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Nullable
    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    @Nonnull
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    @Nullable
    public Directory getSsoDirectory() {
        return this.ssoDirectory;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public boolean isValid() {
        return this.authenticator != null && this.ssoDirectory != null;
    }
}

