/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.crowd.sso;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.ExpiredAuthenticationException;
import com.atlassian.bitbucket.auth.ExpiredPasswordAuthenticationException;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.bitbucket.auth.HttpLogoutHandler;
import com.atlassian.bitbucket.auth.InactiveUserAuthenticationException;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.crowd.sso.CrowdSsoService;
import com.atlassian.bitbucket.crowd.sso.SsoConfiguration;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.model.user.User;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdSsoAuthenticationHandler
implements HttpAuthenticationHandler,
HttpAuthenticationSuccessHandler,
HttpLogoutHandler {
    static final String KEY_CROWD_SSO_AUTHENTICATED = "stash.auth.crowd.sso.authenticated";
    static final String KEY_CROWD_SSO_COOKIE_DOMAIN = "stash.auth.crowd.sso.cookie.domain";
    static final String KEY_CROWD_SSO_COOKIE_SECURE = "stash.auth.crowd.sso.cookie.secure";
    static final String KEY_CROWD_SSO_COOKIE_SESSION_LAST_VALIDATION = "stash.auth.crowd.sso.session.last.validation";
    static final String KEY_CROWD_SSO_COOKIE_TOKEN_KEY = "stash.auth.crowd.sso.cookie.token.key";
    private static final Logger log = LoggerFactory.getLogger(CrowdSsoAuthenticationHandler.class);
    private final AuthenticationService authenticationService;
    private final I18nService i18nService;
    private final CrowdSsoService ssoService;
    private final UserService userService;
    private volatile int logsSuppressed;

    public CrowdSsoAuthenticationHandler(AuthenticationService authenticationService, I18nService i18nService, CrowdSsoService ssoService, UserService userService) {
        this.authenticationService = authenticationService;
        this.i18nService = i18nService;
        this.ssoService = ssoService;
        this.userService = userService;
        this.logsSuppressed = 0;
    }

    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext context) {
        String token;
        HttpServletRequest request = context.getRequest();
        CrowdHttpAuthenticator authenticator = this.ssoService.getAuthenticator();
        if (authenticator == null) {
            log.trace("Skipping Crowd SSO as it is not enabled");
            return null;
        }
        if ("basic".equals(context.getMethod())) {
            log.debug("Skipping Crowd SSO as the request is using BASIC authentication");
            return null;
        }
        if (!this.ssoService.isSsoCandidate(request)) {
            log.debug("Skipping Crowd SSO as the request is using a domain which is not configured for SSO. Domain: {}", (Object)request.getServerName());
            return null;
        }
        String username = context.getUsername();
        String password = context.getCredentials() instanceof String ? (String)context.getCredentials() : null;
        User user = null;
        try {
            if (StringUtils.isBlank((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
                token = authenticator.getToken(request);
                if (token != null && !authenticator.checkAuthenticated(request, context.getResponse()).isAuthenticated()) {
                    this.clearRemoteSsoSession(request, context.getResponse());
                    return null;
                }
                user = authenticator.getUser(request);
                if (user != null && !this.ssoService.userAuthenticated(user.getName())) {
                    return null;
                }
            } else if (this.ssoService.isManagedBySso(username)) {
                user = authenticator.authenticate(request, context.getResponse(), username, password);
            } else {
                log.debug("Bypassing SSO for non-Crowd user {}", (Object)username);
            }
        }
        catch (ApplicationPermissionException | OperationFailedException e) {
            this.logThrottled("Authentication with remote Crowd server failed.", (Exception)e);
            return null;
        }
        catch (InvalidAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.invalidCredentials());
        }
        catch (ApplicationAccessDeniedException e) {
            throw new InactiveUserAuthenticationException(this.noAccess());
        }
        catch (ExpiredCredentialException e) {
            throw new ExpiredPasswordAuthenticationException(this.passwordExpired());
        }
        catch (InactiveAccountException e) {
            throw new InactiveUserAuthenticationException(this.inactiveAccount());
        }
        catch (InvalidTokenException e) {
            this.clearRemoteSsoSession(request, context.getResponse());
            return null;
        }
        if (user == null) {
            return null;
        }
        token = authenticator.getToken(request);
        request.getSession().setAttribute(KEY_CROWD_SSO_AUTHENTICATED, (Object)token);
        ApplicationUser applicationUser = this.userService.getUserByName(user.getName());
        if (applicationUser == null) {
            return null;
        }
        AuthenticationResult.Builder authenticationResultBuilder = new AuthenticationResult.Builder(applicationUser);
        if (token != null) {
            authenticationResultBuilder.property(KEY_CROWD_SSO_AUTHENTICATED, (Serializable)((Object)token));
            SsoConfiguration ssoConfiguration = this.ssoService.getConfiguration();
            Optional.ofNullable(ssoConfiguration.getClientProperties()).ifPresent(clientProperties -> {
                authenticationResultBuilder.property(KEY_CROWD_SSO_COOKIE_TOKEN_KEY, (Serializable)((Object)clientProperties.getCookieTokenKey()));
                authenticationResultBuilder.property(KEY_CROWD_SSO_COOKIE_SESSION_LAST_VALIDATION, (Serializable)((Object)clientProperties.getSessionLastValidation()));
                if (StringUtils.isNotBlank((CharSequence)clientProperties.getSSOCookieDomainName())) {
                    authenticationResultBuilder.property(KEY_CROWD_SSO_COOKIE_DOMAIN, (Serializable)((Object)clientProperties.getSSOCookieDomainName()));
                }
            });
            authenticationResultBuilder.property(KEY_CROWD_SSO_COOKIE_SECURE, (Serializable)Boolean.valueOf(ssoConfiguration.isCookieSecure()));
        }
        return authenticationResultBuilder.build();
    }

    public void logout(@Nonnull ApplicationUser user, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        HttpSession session;
        CrowdHttpAuthenticator authenticator = this.ssoService.getAuthenticator();
        if (authenticator != null && (session = request.getSession(false)) != null && session.getAttribute(KEY_CROWD_SSO_AUTHENTICATED) != null) {
            session.removeAttribute(KEY_CROWD_SSO_AUTHENTICATED);
            try {
                authenticator.logout(request, response);
            }
            catch (CrowdException | PermissionException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Could not log out " + user.getName() + " in remote Crowd {}", e);
                }
                log.info("Could not log out {} in remote Crowd {}", (Object)user.getName(), (Object)e.getMessage());
            }
        }
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) {
        String username = context.getUser().getName();
        if (this.isNotAuthenticatedBySso((HttpAuthenticationContext)context) && this.ssoService.isManagedBySso(username)) {
            try {
                this.ssoService.getAuthenticator().authenticateWithoutValidatingPassword(context.getRequest(), context.getResponse(), username);
            }
            catch (Exception e) {
                log.info("Could not create SSO session for user {}: {}", (Object)context.getUsername(), (Object)e.getMessage());
                log.debug("Error while authenticating for Crowd SSO", (Throwable)e);
            }
        }
        return false;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext context) {
        if (this.isNotAuthenticatedBySso(context)) {
            return;
        }
        CrowdHttpAuthenticator authenticator = this.ssoService.getAuthenticator();
        if (authenticator != null) {
            String token = authenticator.getToken(context.getRequest());
            String tokenFromSession = this.getAuthenticatedToken(context.getRequest());
            if (token != null && token.equals(tokenFromSession) && this.isAuthenticatedRemotely(authenticator, context.getRequest(), context.getResponse())) {
                return;
            }
            log.debug("Token is no longer valid token: {} session token: {}", (Object)token, (Object)tokenFromSession);
        }
        this.logoutUser(context);
        throw new ExpiredAuthenticationException(this.tokenExpired());
    }

    private KeyedMessage inactiveAccount() {
        return this.i18nService.createKeyedMessage("bitbucket.auth.crowd.sso.inactive.account", new Object[0]);
    }

    private KeyedMessage invalidCredentials() {
        return this.i18nService.createKeyedMessage("bitbucket.auth.failed", new Object[0]);
    }

    private KeyedMessage tokenExpired() {
        return this.i18nService.createKeyedMessage("bitbucket.auth.crowd.sso.token.expired", new Object[0]);
    }

    private KeyedMessage noAccess() {
        return this.i18nService.createKeyedMessage("bitbucket.auth.crowd.sso.no.permission", new Object[]{Product.NAME});
    }

    private KeyedMessage passwordExpired() {
        return this.i18nService.createKeyedMessage("bitbucket.auth.crowd.sso.credentials.expired", new Object[0]);
    }

    private void clearRemoteSsoSession(HttpServletRequest request, HttpServletResponse response) {
        CrowdHttpAuthenticator authenticator = this.ssoService.getAuthenticator();
        if (authenticator != null) {
            try {
                authenticator.logout(request, response);
            }
            catch (Exception e) {
                log.debug("An error occurred during Crowd SSO logout", (Throwable)e);
            }
        }
    }

    private String getAuthenticatedToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null ? (String)session.getAttribute(KEY_CROWD_SSO_AUTHENTICATED) : null;
    }

    private boolean isAuthenticatedRemotely(CrowdHttpAuthenticator authenticator, HttpServletRequest request, HttpServletResponse response) {
        try {
            return authenticator.checkAuthenticated(request, response).isAuthenticated();
        }
        catch (OperationFailedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to validate SSO session", (Throwable)e);
            } else {
                log.info("Failed to validate SSO session {}", (Object)e.getMessage());
            }
            return false;
        }
    }

    private boolean isNotAuthenticatedBySso(HttpAuthenticationContext token) {
        HttpSession session = token.getRequest().getSession(false);
        return session == null || session.getAttribute(KEY_CROWD_SSO_AUTHENTICATED) == null;
    }

    private void logThrottled(String message, Exception e) {
        if (++this.logsSuppressed % 100 == 1) {
            this.logsSuppressed = 1;
            log.warn(message, (Throwable)e);
        } else {
            log.debug(message, (Throwable)e);
        }
    }

    private void logoutUser(HttpAuthenticationContext context) {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        request.getSession().removeAttribute(KEY_CROWD_SSO_AUTHENTICATED);
        this.authenticationService.clear();
        this.clearRemoteSsoSession(request, response);
    }
}

