/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.crowd.sso;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.crowd.sso.CrowdSsoService;
import com.atlassian.bitbucket.crowd.sso.SsoConfiguration;
import com.atlassian.bitbucket.event.server.BaseUrlChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.crowd.sso.SsoConfigurationCache;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticatorImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.event.api.EventListener;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.atlassian.util.concurrent.LazyReference;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultCrowdSsoService
implements CrowdSsoService,
DisposableBean {
    static final String PROP_PREFIX = "plugin.auth-crowd.sso.";
    static final String PROP_ENABLED = "plugin.auth-crowd.sso.enabled";
    static final String PROP_CONFIG_ERROR_WAIT = "plugin.auth-crowd.sso.config.error.wait";
    static final String PROP_CONFIG_TTL = "plugin.auth-crowd.sso.config.ttl";
    static final String PROP_CONFIG_DISABLE_AUTH_NOTIFICATION = "plugin.auth-crowd.sso.config.user.authenticated.notification.skip";
    static final String PROP_CONFIG_AUTH_NOTIFICATION_THROTTLE = "plugin.auth-crowd.sso.config.user.authenticated.notification.expiration";
    static final SsoConfiguration DISABLED_CONFIGURATION = new SsoConfiguration(null, null, null, null, false);
    private static final Logger log = LoggerFactory.getLogger(DefaultCrowdSsoService.class);
    private final CrowdService crowdService;
    private final CrowdDirectoryService directoryService;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final RestCrowdClientFactory restClientFactory;
    private final SsoConfigurationCache configCache;
    private final boolean enabled;
    private final LazyReference<Properties> ssoProperties;
    private final boolean skipAuthNotifications;
    private final Cache<String, Boolean> authNotificationThrottle;

    public DefaultCrowdSsoService(CacheFactory cacheFactory, CrowdService crowdService, CrowdDirectoryService directoryService, I18nService i18nService, NavBuilder navBuilder, final ApplicationPropertiesService propertiesService, RestCrowdClientFactory restCrowdClientFactory) {
        this.crowdService = crowdService;
        this.directoryService = directoryService;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.restClientFactory = restCrowdClientFactory;
        this.configCache = new SsoConfigurationCache(cacheFactory, new SsoConfigurationSupplier(), propertiesService.getPluginProperty(PROP_CONFIG_TTL, 15), TimeUnit.MINUTES, propertiesService.getPluginProperty(PROP_CONFIG_ERROR_WAIT, 1), TimeUnit.SECONDS);
        this.enabled = Boolean.parseBoolean(propertiesService.getPluginProperty(PROP_ENABLED));
        this.ssoProperties = new LazyReference<Properties>(){

            protected Properties create() throws Exception {
                return DefaultCrowdSsoService.this.loadClientConfigurationProperties(propertiesService);
            }
        };
        long userAuthenticatedRefreshExpiration = propertiesService.getPluginProperty(PROP_CONFIG_AUTH_NOTIFICATION_THROTTLE, 60);
        this.authNotificationThrottle = CacheBuilder.newBuilder().expireAfterWrite(userAuthenticatedRefreshExpiration, TimeUnit.SECONDS).build();
        this.skipAuthNotifications = propertiesService.getPluginProperty(PROP_CONFIG_DISABLE_AUTH_NOTIFICATION, false);
    }

    public void destroy() throws Exception {
        this.configCache.destroy();
    }

    @Override
    public CrowdHttpAuthenticator getAuthenticator() {
        return this.getConfiguration().getAuthenticator();
    }

    public boolean isAvailable() {
        return this.getConfiguration().isValid();
    }

    @Override
    public boolean isManagedBySso(@Nonnull String username) {
        SsoConfiguration conf = this.getConfiguration();
        if (conf.isValid()) {
            User user = this.crowdService.getUser(username);
            return user != null && conf.getSsoDirectory().getId().longValue() == user.getDirectoryId();
        }
        return false;
    }

    @Override
    public boolean userAuthenticated(@Nonnull String username) {
        if (this.skipAuthNotifications) {
            return true;
        }
        try {
            return (Boolean)this.authNotificationThrottle.get((Object)username, () -> {
                try {
                    User updatedUser = this.crowdService.userAuthenticated(username);
                    return updatedUser != null;
                }
                catch (InactiveAccountException | UserNotFoundException e) {
                    log.warn("User {} not found/inactive during CrowdService.userAuthenticated", (Object)username, (Object)e);
                    return false;
                }
                catch (OperationFailedException e) {
                    log.info("Error executing CrowdService.userAuthenticated for user {}, falling back to local user", (Object)username, (Object)e);
                    return true;
                }
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            log.warn("Error executing userAuthenticated for user {}", (Object)username, (Object)e);
            return true;
        }
    }

    @Override
    public boolean isSsoCandidate(HttpServletRequest request) {
        SsoConfiguration conf = this.getConfiguration();
        return conf.isValid() && (conf.getCookieDomain().isEmpty() || request.getServerName().endsWith(conf.getCookieDomain()));
    }

    @EventListener
    public void onBaseUrlChanged(BaseUrlChangedEvent event) {
        ((Properties)this.ssoProperties.get()).put("application.login.url", this.navBuilder.login().buildConfigured());
        this.reset();
    }

    @EventListener
    public void onDirectoryCreated(DirectoryCreatedEvent event) {
        this.reset();
    }

    @EventListener
    public void onDirectoryDeleted(DirectoryDeletedEvent event) {
        this.reset();
    }

    @EventListener
    public void onDirectoryUpdatedEvent(DirectoryUpdatedEvent event) {
        this.reset();
    }

    private Properties createCookieProperties(CookieConfiguration cookieConfiguration) {
        Properties properties = new Properties();
        properties.put("cookie.tokenkey", cookieConfiguration.getName());
        if (StringUtils.isNotBlank((CharSequence)cookieConfiguration.getDomain())) {
            properties.put("cookie.domain", StringUtils.trimToEmpty((String)cookieConfiguration.getDomain()));
        }
        return properties;
    }

    private ClientProperties createCrowdClientProperties(Directory directory, Properties customProperties) {
        Properties properties = new Properties();
        Map dirAttributes = directory.getAttributes();
        properties.putAll((Map<?, ?>)((Map)this.ssoProperties.get()));
        properties.put("application.name", dirAttributes.get("application.name"));
        properties.put("application.password", dirAttributes.get("application.password"));
        properties.put("crowd.base.url", dirAttributes.get("crowd.server.url"));
        if (customProperties != null) {
            properties.putAll((Map<?, ?>)customProperties);
        }
        return ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
    }

    private CookieConfiguration fetchCookieConfiguration(CrowdClient crowdClient, String crowdBaseUrl) {
        try {
            CookieConfiguration config = crowdClient.getCookieConfiguration();
            if (StringUtils.isNotBlank((CharSequence)config.getName())) {
                return config;
            }
            log.debug("Cookie configuration from Crowd at {} did not have a name. This may indicate an unexpected response from the Crowd server. Is the Crowd URL valid?", (Object)crowdBaseUrl);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException | com.atlassian.crowd.exception.OperationFailedException e) {
            throw this.newConfigFetchFailedException((Exception)e);
        }
        return null;
    }

    @Override
    public SsoConfiguration getConfiguration() {
        if (!this.enabled) {
            return DISABLED_CONFIGURATION;
        }
        return this.configCache.get().orElse(DISABLED_CONFIGURATION);
    }

    private void loadProperty(ApplicationPropertiesService propertiesService, Properties properties, String key) {
        String value = propertiesService.getPluginProperty(PROP_PREFIX + key);
        if (value != null) {
            properties.put(key, value);
        }
    }

    private Properties loadClientConfigurationProperties(ApplicationPropertiesService propertiesService) {
        Properties result = new Properties();
        this.loadProperty(propertiesService, result, "cookie.domain");
        this.loadProperty(propertiesService, result, "cookie.tokenkey");
        this.loadProperty(propertiesService, result, "http.max.connections");
        this.loadProperty(propertiesService, result, "http.proxy.host");
        this.loadProperty(propertiesService, result, "http.proxy.port");
        this.loadProperty(propertiesService, result, "http.proxy.username");
        this.loadProperty(propertiesService, result, "http.proxy.password");
        this.loadProperty(propertiesService, result, "http.timeout");
        this.loadProperty(propertiesService, result, "session.lastvalidation");
        this.loadProperty(propertiesService, result, "session.tokenkey");
        this.loadProperty(propertiesService, result, "session.validationinterval");
        this.loadProperty(propertiesService, result, "socket.timeout");
        result.put("application.login.url", this.navBuilder.login().buildConfigured());
        return result;
    }

    private ServerException newConfigFetchFailedException(Exception e) {
        throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.auth.crowd.sso.configuration.fetch.failed", new Object[]{e.getMessage()}), (Throwable)e);
    }

    private void reset() {
        this.configCache.reset();
    }

    private class SsoConfigurationSupplier
    implements Supplier<Optional<SsoConfiguration>> {
        private SsoConfigurationSupplier() {
        }

        public Optional<SsoConfiguration> get() {
            for (Directory directory : DefaultCrowdSsoService.this.directoryService.findAllDirectories()) {
                CrowdHttpTokenHelper tokenHelper;
                ClientProperties clientProperties;
                CrowdClient crowdClient;
                CookieConfiguration cookieConfiguration;
                if (!directory.isActive() || directory.getType() != DirectoryType.CROWD || (cookieConfiguration = DefaultCrowdSsoService.this.fetchCookieConfiguration(crowdClient = DefaultCrowdSsoService.this.restClientFactory.newInstance(clientProperties = DefaultCrowdSsoService.this.createCrowdClientProperties(directory, null)), clientProperties.getBaseURL())) == null) continue;
                clientProperties = DefaultCrowdSsoService.this.createCrowdClientProperties(directory, DefaultCrowdSsoService.this.createCookieProperties(cookieConfiguration));
                CrowdHttpAuthenticatorImpl authenticator = new CrowdHttpAuthenticatorImpl(crowdClient, clientProperties, tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance()));
                SsoConfiguration config = new SsoConfiguration((CrowdHttpAuthenticator)authenticator, cookieConfiguration.getDomain(), directory, clientProperties, cookieConfiguration.isSecure());
                if (!config.isValid()) {
                    log.info("Disabling Crowd SSO integration because the remote Crowd SSO configuration is invalid.");
                    throw new ServerException(DefaultCrowdSsoService.this.i18nService.createKeyedMessage("bitbucket.auth.crowd.sso.invalid.configuration", new Object[]{directory.getName()}));
                }
                log.debug("Crowd SSO integration with directory {} has been (re)configured and enabled", (Object)directory.getName());
                return Optional.of(config);
            }
            return Optional.empty();
        }
    }
}

