/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.crowd.sso;

import com.atlassian.bitbucket.crowd.sso.SsoConfiguration;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceAdapter;
import com.atlassian.cache.CachedReferenceEvent;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.cache.Supplier;
import com.atlassian.failurecache.failures.ExponentialBackOffFailureCache;
import com.atlassian.failurecache.failures.FailureCache;
import com.atlassian.failurecache.util.date.Clock;
import com.atlassian.failurecache.util.date.SystemClock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoConfigurationCache {
    private static final String FAILURE_KEY = "config";
    private static final Logger log = LoggerFactory.getLogger(SsoConfigurationCache.class);
    private final CachedReference<Optional<SsoConfiguration>> configCache;
    private final FailureCache<String> failureCache;
    private final CachedReferenceListener<Optional<SsoConfiguration>> invalidationListener;
    private volatile boolean destroyed;

    public SsoConfigurationCache(CacheFactory cacheFactory, Supplier<Optional<SsoConfiguration>> configSupplier, long ttl, TimeUnit ttlTimeUnit, long initialRetryWait, TimeUnit retryTimeUnit) {
        this(cacheFactory, configSupplier, ttl, ttlTimeUnit, initialRetryWait, retryTimeUnit, (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    SsoConfigurationCache(CacheFactory cacheFactory, Supplier<Optional<SsoConfiguration>> configSupplier, long ttl, TimeUnit ttlTimeUnit, long initialRetryWait, TimeUnit retryTimeUnit, Clock clock) {
        this.configCache = cacheFactory.getCachedReference(SsoConfigurationCache.class.getName(), configSupplier, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterAccess(ttl, ttlTimeUnit).build());
        this.failureCache = new ExponentialBackOffFailureCache.Builder().backOffRate(1.5).clock(clock).initialExpiry(initialRetryWait, retryTimeUnit).maxExpiry(ttl, ttlTimeUnit).build();
        this.invalidationListener = new InvalidateFailureCacheListener();
        this.configCache.addListener(this.invalidationListener, false);
    }

    public Optional<SsoConfiguration> get() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Destroyed");
        if (!this.failureCache.isFailing((Object)FAILURE_KEY)) {
            try {
                Optional config = (Optional)this.configCache.get();
                this.failureCache.registerSuccess((Object)FAILURE_KEY);
                return config;
            }
            catch (Exception e) {
                log.debug("Failed to retrieve SSO configuration", (Throwable)e);
                this.failureCache.registerFailure((Object)FAILURE_KEY);
            }
        }
        return Optional.empty();
    }

    public void reset() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Destroyed");
        this.configCache.reset();
        this.invalidateFailureCache();
    }

    private void invalidateFailureCache() {
        this.failureCache.registerSuccess((Object)FAILURE_KEY);
    }

    public void destroy() {
        if (!this.destroyed) {
            this.configCache.removeListener(this.invalidationListener);
            this.destroyed = true;
        }
    }

    private class InvalidateFailureCacheListener
    extends CachedReferenceAdapter<Optional<SsoConfiguration>> {
        private InvalidateFailureCacheListener() {
        }

        public void onEvict(@Nonnull CachedReferenceEvent<Optional<SsoConfiguration>> event) {
            SsoConfigurationCache.this.invalidateFailureCache();
        }

        public void onReset(@Nonnull CachedReferenceEvent<Optional<SsoConfiguration>> event) {
            SsoConfigurationCache.this.invalidateFailureCache();
        }
    }
}

