/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.crowd.sso;

import com.atlassian.bitbucket.crowd.sso.SsoConfiguration;
import com.atlassian.bitbucket.internal.crowd.sso.DefaultCrowdSsoService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import com.google.common.annotations.VisibleForTesting;

public class SsoSupportData
implements SupportDataAppender<Directory> {
    static final String ATST_DIRECTORY_SSO = "bitbucket.atst.crowd.embedded.directories.directory.sso";
    private final DefaultCrowdSsoService defaultCrowdSsoService;

    public SsoSupportData(DefaultCrowdSsoService defaultCrowdSsoService) {
        this.defaultCrowdSsoService = defaultCrowdSsoService;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Directory directory) {
        SsoConfiguration currentConfig = this.defaultCrowdSsoService.getConfiguration();
        SsoSupportData.addSsoSupportData(supportDataBuilder, directory, currentConfig);
    }

    @VisibleForTesting
    static void addSsoSupportData(SupportDataBuilder supportDataBuilder, Directory directory, SsoConfiguration currentConfig) {
        if (currentConfig == null || currentConfig.getSsoDirectory() == null || !directory.getId().equals(currentConfig.getSsoDirectory().getId())) {
            return;
        }
        ClientProperties clientProperties = currentConfig.getClientProperties();
        SupportDataBuilder ssoDataBuilder = supportDataBuilder.addCategory(ATST_DIRECTORY_SSO);
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.authentication.url", clientProperties.getApplicationAuthenticationURL());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.application.name", clientProperties.getApplicationName());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.base.url", clientProperties.getBaseURL());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.cookie.tokenkey", clientProperties.getCookieTokenKey());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.http.proxy.host", clientProperties.getHttpProxyHost());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.http.proxy.port", clientProperties.getHttpProxyPort());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.http.proxy.username", clientProperties.getHttpProxyUsername());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.session.tokenkey", clientProperties.getSessionTokenKey());
        ssoDataBuilder.addValue("bitbucket.atst.crowd.embedded.directories.directory.sso.sso.domain", clientProperties.getSSOCookieDomainName());
    }
}

