/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu;

import com.atlassian.zdu.internal.api.ClusterManagerAdapter;
import com.atlassian.zdu.internal.api.NodeInfo;
import com.atlassian.zdu.persistence.ZduNodeRepository;
import com.atlassian.zdu.rest.dto.NodeInfoDTO;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class NodeInfoAccessor {
    private final ClusterManagerAdapter clusterManagerAdapter;
    private final ZduNodeRepository persistenceService;

    public NodeInfoAccessor(@Nonnull ClusterManagerAdapter clusterManagerAdapter, @Nonnull ZduNodeRepository persistenceService) {
        this.clusterManagerAdapter = Objects.requireNonNull(clusterManagerAdapter);
        this.persistenceService = Objects.requireNonNull(persistenceService);
    }

    public List<NodeInfo> getNodes() {
        List<NodeInfo> previousNodes = this.persistenceService.get();
        List<NodeInfo> currentNodes = this.clusterManagerAdapter.getNodes().stream().map(n -> NodeInfoDTO.builder(n).build()).map(NodeInfo.class::cast).toList();
        return this.addOfflineNodes(currentNodes, previousNodes);
    }

    public void snapshotNodes() {
        List<NodeInfoDTO> currentNodes = this.clusterManagerAdapter.getNodes().stream().map(n -> NodeInfoDTO.builder(n).build()).toList();
        this.persistenceService.cleanAll();
        this.persistenceService.put(currentNodes);
    }

    private List<NodeInfo> addOfflineNodes(List<NodeInfo> currentNodes, List<NodeInfo> previousNodes) {
        return Stream.concat(currentNodes.stream(), previousNodes.stream()).distinct().toList();
    }
}

