/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.zdu.internal.api.ClusterManagerAdapter;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SystemAdminOnly
public class TemplateServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(TemplateServlet.class);
    private final SoyTemplateRenderer templateRenderer;
    private final PermissionEnforcer permissionEnforcer;
    private final LoginUriProvider loginUriProvider;
    private final ApplicationProperties applicationProperties;
    private final ClusterManagerAdapter clusterManagerAdapter;

    public TemplateServlet(SoyTemplateRenderer templateRenderer, PermissionEnforcer permissionEnforcer, LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties, ClusterManagerAdapter clusterManagerAdapter) {
        this.templateRenderer = templateRenderer;
        this.permissionEnforcer = permissionEnforcer;
        this.loginUriProvider = loginUriProvider;
        this.applicationProperties = applicationProperties;
        this.clusterManagerAdapter = clusterManagerAdapter;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (this.permissionEnforcer.isSystemAdmin()) {
                this.render(response);
            } else if (this.permissionEnforcer.isAuthenticated()) {
                response.sendError(403);
            } else {
                response.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(request.getRequestURL().toString())).toASCIIString());
            }
        }
        catch (IOException exception) {
            log.error("Unable to render template", (Throwable)exception);
            response.sendError(500);
        }
    }

    private void render(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        String templateKey = "com.atlassian.zdu.refapp-zdu-plugin:soy-templates";
        String templateName = "zdu.clustered";
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("confluence")) {
            templateKey = "com.atlassian.zdu.confluence-zdu-plugin:soy-templates";
            if (!this.clusterManagerAdapter.isClustered()) {
                templateName = "zdu.sndc";
            }
        }
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("bitbucket")) {
            templateKey = "com.atlassian.zdu.bitbucket-zdu-plugin:soy-templates";
        }
        this.templateRenderer.render((Appendable)response.getWriter(), templateKey, templateName, Map.of("productName", this.applicationProperties.getDisplayName()));
    }
}

