/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.bitbucket.impl;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.server.ApplicationState;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.zdu.internal.api.ClusterManagerAdapter;
import com.atlassian.zdu.internal.api.NodeInfo;
import com.atlassian.zdu.rest.dto.NodeInfoDTO;
import com.atlassian.zdu.rest.dto.NodeState;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BitbucketClusterManagerAdapter
implements ClusterManagerAdapter {
    private final ClusterService clusterService;

    public BitbucketClusterManagerAdapter(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public List<NodeInfo> getNodes() {
        Map states = this.clusterService.getNodeStates();
        return this.clusterService.getInformation().getNodes().stream().map(node -> this.asClusterNode((ClusterNode)node, states)).toList();
    }

    @Override
    public boolean isClustered() {
        return this.clusterService.isAvailable();
    }

    @Override
    public boolean hasClusterFinalizationTasks() {
        return false;
    }

    @Override
    public boolean supportsFinalizationTasks() {
        return false;
    }

    private NodeInfo asClusterNode(ClusterNode node, Map<ClusterNode, ApplicationState> states) {
        Version version = node.getBuildVersion();
        return NodeInfoDTO.builder().id(node.getId()).name((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{node.getName()})).ipAddress(node.getAddress().getHostString()).portNumber(node.getAddress().getPort()).state(BitbucketClusterManagerAdapter.translateState(states.get(node))).buildNumber(BitbucketClusterManagerAdapter.calculateBuildNumber(version)).version(BitbucketClusterManagerAdapter.normalizeVersion(version.toString())).local(node.isLocal()).build();
    }

    private static NodeState translateState(ApplicationState state) {
        if (state == null) {
            return NodeState.OFFLINE;
        }
        return switch (state) {
            case ApplicationState.STARTING, ApplicationState.FIRST_RUN -> NodeState.STARTING;
            case ApplicationState.RUNNING -> NodeState.ACTIVE;
            case ApplicationState.STOPPING -> NodeState.TERMINATING;
            default -> NodeState.ERROR;
        };
    }

    private static String normalizeVersion(String version) {
        return version.split("-", 2)[0];
    }

    private static String calculateBuildNumber(Version version) {
        long full = ((long)version.getMajor() * 1000L + (long)version.getMinor()) * 1000L + (long)version.getPatch();
        return String.valueOf(full);
    }
}

