/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.bitbucket.impl;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.bitbucket.zdu.RollingUpgradeService;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketRollingUpgradeService
implements com.atlassian.zdu.internal.api.RollingUpgradeService {
    private static final Logger log = LoggerFactory.getLogger(BitbucketRollingUpgradeService.class);
    private final RollingUpgradeService rollingUpgradeService;

    public BitbucketRollingUpgradeService(RollingUpgradeService rollingUpgradeService) {
        this.rollingUpgradeService = Objects.requireNonNull(rollingUpgradeService);
    }

    @Override
    public boolean isUpgradeModeEnabled() {
        return this.rollingUpgradeService.isUpgradeModeEnabled();
    }

    @Override
    public Optional<String> getOriginalVersion() {
        return this.rollingUpgradeService.getOriginalVersion().map(Version::toString);
    }

    @Override
    public void enableUpgradeMode() {
        log.info("enabling rolling upgrade");
        this.rollingUpgradeService.enableUpgradeMode();
    }

    @Override
    public void disableUpgradeMode() {
        log.info("disabling rolling upgrade");
        this.rollingUpgradeService.disableUpgradeMode();
    }

    @Override
    public void retryFinalization() {
    }
}

