/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.impl;

import com.atlassian.zdu.api.BannerService;
import com.atlassian.zdu.api.ZduService;
import com.atlassian.zdu.internal.api.ClusterManagerAdapter;
import com.atlassian.zdu.internal.api.RollingUpgradeService;
import com.atlassian.zdu.rest.dto.BannerState;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class BannerServiceImpl
implements BannerService {
    private final ClusterManagerAdapter clusterManagerAdapter;
    private final RollingUpgradeService rollingUpgradeService;
    private final ZduService zduService;

    public BannerServiceImpl(@Nonnull ClusterManagerAdapter clusterManagerAdapter, @Nonnull RollingUpgradeService rollingUpgradeService, @Nonnull ZduService zduService) {
        this.clusterManagerAdapter = Objects.requireNonNull(clusterManagerAdapter);
        this.rollingUpgradeService = Objects.requireNonNull(rollingUpgradeService);
        this.zduService = Objects.requireNonNull(zduService);
    }

    @Override
    public BannerState getState() {
        if (this.clusterManagerAdapter.supportsFinalizationTasks()) {
            return BannerState.fromClusterState(this.zduService.getState());
        }
        return this.rollingUpgradeService.isUpgradeModeEnabled() ? BannerState.UPGRADE_IN_PROGRESS : BannerState.HIDDEN;
    }
}

