/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.rest.filter;

import com.atlassian.plugins.rest.api.model.Status;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.zdu.rest.filter.annotations.SysadminOnly;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.ext.Provider;

@Provider
@Priority(value=2000)
@SysadminOnly
public class SysadminOnlyFilter
implements ContainerRequestFilter {
    private final UserManager userManager;

    @Inject
    public SysadminOnlyFilter(UserManager userManager) {
        this.userManager = userManager;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            throw new IllegalStateException("Unauthenticated users should be handled by Atlassian REST.");
        }
        if (!this.userManager.isSystemAdmin(userKey)) {
            containerRequestContext.abortWith(Status.forbidden().message("Client is not authorized to access this resource.").responseBuilder().type(Status.variantFor((Request)containerRequestContext.getRequest())).build());
        }
    }
}

