/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks;

import com.atlassian.bitbucket.hook.repository.DisableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragment;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractBundledHookRestFragment
implements RestFragment {
    private final I18nService i18nService;
    private final RepositoryHookService repositoryHookService;
    private final SecurityService securityService;

    public AbstractBundledHookRestFragment(I18nService i18nService, RepositoryHookService repositoryHookService, SecurityService securityService) {
        this.i18nService = i18nService;
        this.repositoryHookService = repositoryHookService;
        this.securityService = securityService;
    }

    @Nonnull
    public Map<String, Object> execute(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Objects.requireNonNull(fragmentContext, "fragmentContext");
        Objects.requireNonNull(requestContext, "requestContext");
        Repository repository = AbstractBundledHookRestFragment.getRepository(requestContext).orElseThrow(() -> new IllegalStateException("The requestContext should contain a repository"));
        String method = fragmentContext.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            return this.doGet(repository);
        }
        if ("POST".equalsIgnoreCase(method)) {
            return this.doPost(fragmentContext, repository);
        }
        return ImmutableMap.of((Object)this.getHookField(), (Object)this.i18nService.getMessage("bitbucket.plugins.bundled.hooks.rest.method.unsupported", new Object[]{this.getHookName(), method}));
    }

    @Nonnull
    public Map<String, Object> validate(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Objects.requireNonNull(fragmentContext, "fragmentContext");
        Objects.requireNonNull(requestContext, "requestContext");
        if ("POST".equalsIgnoreCase(fragmentContext.getMethod())) {
            if (!AbstractBundledHookRestFragment.getRepository(requestContext).isPresent()) {
                return new RestErrorMessage("requestContext", this.i18nService.getMessage("bitbucket.plugins.bundled.hooks.rest.requestContext", new Object[0]));
            }
            if (this.hasEnabledProperty(fragmentContext) && !this.getEnabledProperty(fragmentContext).isPresent()) {
                return new RestErrorMessage(this.getHookField(), this.i18nService.getMessage("bitbucket.plugins.bundled.hooks.rest.fragmentContext", new Object[0]));
            }
        }
        return ImmutableMap.of();
    }

    protected abstract String getHookField();

    protected abstract String getHookName();

    private static Optional<Repository> getRepository(@Nonnull Map<String, Object> requestContext) {
        if (requestContext.containsKey("repository") && requestContext.get("repository") instanceof Repository) {
            return Optional.of((Repository)requestContext.get("repository"));
        }
        return Optional.empty();
    }

    private Map<String, Object> doGet(Repository repository) {
        Boolean isEnabled = (Boolean)this.securityService.withPermission(Permission.REPO_ADMIN, "Retrieving whether " + this.getHookKey() + " is enabled").call(() -> this.isEnabled(repository));
        return ImmutableMap.of((Object)this.getHookField(), (Object)isEnabled);
    }

    private Map<String, Object> doPost(@Nonnull RestFragmentContext fragmentContext, Repository repository) {
        Boolean shouldEnable;
        if (this.hasEnabledProperty(fragmentContext) && (shouldEnable = this.getEnabledProperty(fragmentContext).orElseThrow(() -> new IllegalStateException("The fragmentContext should contain " + this.getHookField() + " field"))).booleanValue() != this.isEnabled(repository)) {
            if (shouldEnable.booleanValue()) {
                this.repositoryHookService.enable(new EnableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), this.getHookKey()).build());
            } else {
                this.repositoryHookService.disable(new DisableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), this.getHookKey()).build());
            }
        }
        return this.doGet(repository);
    }

    private Optional<Boolean> getEnabledProperty(RestFragmentContext fragmentContext) {
        return fragmentContext.getBodyProperty(this.getHookField()).filter(value -> value instanceof Boolean).map(isEnabled -> (Boolean)isEnabled);
    }

    private String getHookKey() {
        return "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:" + this.getHookName();
    }

    private boolean hasEnabledProperty(@Nonnull RestFragmentContext fragmentContext) {
        return fragmentContext.getBodyProperty(this.getHookField()).isPresent();
    }

    private boolean isEnabled(@Nonnull Repository repository) {
        RepositoryHook hook = this.repositoryHookService.getByKey((Scope)Scopes.repository((Repository)repository), this.getHookKey());
        return hook != null && hook.isEnabled();
    }
}

