/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.allapprovers;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import jakarta.annotation.Nonnull;

public class AllApproversMergeCheck
implements RepositoryMergeCheck {
    private final I18nService i18nService;

    public AllApproversMergeCheck(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        if (request.getPullRequest().getReviewers().stream().anyMatch(reviewer -> !reviewer.isApproved())) {
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.pull.require.all.approvals.for.merge.label", new Object[0]), (String)this.i18nService.getMessage("bitbucket.pull.require.all.approvals.for.merge.message", new Object[0]));
        }
        return RepositoryHookResult.accepted();
    }
}

