/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.allapprovers;

import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.upgrades.MergeCheckToHooksV2MigrationJob;
import java.util.List;

public class AllApproversMergeCheckMigrationJob
implements MergeCheckToHooksV2MigrationJob {
    private final PluginSettings pluginSettings;
    private final RepositoryHookService repositoryHookService;

    public AllApproversMergeCheckMigrationJob(PluginSettingsFactory factory, RepositoryHookService repositoryHookService) {
        this.pluginSettings = factory.createSettingsForKey("com.atlassian.bitbucket.server.bitbucket-bundled-hooks");
        this.repositoryHookService = repositoryHookService;
    }

    @Override
    public void cleanup(List<Integer> repositoryIds) {
        repositoryIds.forEach(repoId -> this.pluginSettings.remove(this.createKey((int)repoId)));
    }

    @Override
    public String getHookName() {
        return "All approvers merge check";
    }

    @Override
    public boolean migrate(Repository repository) {
        String settingsKey = this.createKey(repository.getId());
        Object settings = this.pluginSettings.get(settingsKey);
        if (Boolean.parseBoolean(String.valueOf(settings))) {
            this.repositoryHookService.enable(new EnableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:all-approvers-merge-check").build());
            return true;
        }
        return false;
    }

    private String createKey(int repositoryId) {
        return "repo." + repositoryId + ".requireAllApprovers";
    }
}

