/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.approvers;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragment;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.atlassian.stash.internal.plugin.hooks.approvers.RequiredApproversHelper;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;

public class DeprecatedRequiredApproversRestFragment
implements RestFragment {
    private static final String REQUIRED_APPROVERS_KEY = "requiredApprovers";
    private final RequiredApproversHelper helper;
    private final I18nService i18nService;

    public DeprecatedRequiredApproversRestFragment(RequiredApproversHelper helper, I18nService i18nService) {
        this.helper = helper;
        this.i18nService = i18nService;
    }

    @Nonnull
    public Map<String, Object> execute(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Repository repository = (Repository)requestContext.get("repository");
        if (fragmentContext.getMethod().equals("GET")) {
            return this.doGet(repository);
        }
        if (fragmentContext.getMethod().equals("POST")) {
            return this.doPost(fragmentContext, repository);
        }
        return ImmutableMap.of((Object)REQUIRED_APPROVERS_KEY, (Object)this.i18nService.getMessage("bitbucket.requiredApprovers.rest.method.unsupported", new Object[]{fragmentContext.getMethod()}));
    }

    @Nonnull
    public Map<String, Object> validate(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Optional property;
        if (fragmentContext.getMethod().equals("POST") && (property = fragmentContext.getBodyProperty(REQUIRED_APPROVERS_KEY)).isPresent()) {
            if (property.get() instanceof Number) {
                int approversCount = ((Number)property.get()).intValue();
                if (approversCount < 0) {
                    return new RestErrorMessage(REQUIRED_APPROVERS_KEY, this.i18nService.getMessage("bitbucket.requiredApprovers.count.negativeNumber", new Object[0]));
                }
            } else {
                return new RestErrorMessage(REQUIRED_APPROVERS_KEY, this.i18nService.getMessage("bitbucket.requiredApprovers.count.notANumber", new Object[0]));
            }
        }
        return ImmutableMap.of();
    }

    private Map<String, Object> doGet(Repository repository) {
        return ImmutableMap.of((Object)REQUIRED_APPROVERS_KEY, (Object)this.helper.getCountDeprecated(repository));
    }

    private Map<String, Object> doPost(RestFragmentContext fragmentContext, Repository repository) {
        fragmentContext.getBodyProperty("com.atlassian.bitbucket.server.bitbucket-bundled-hooks:requiredApprovers").orElseGet(() -> {
            fragmentContext.getBodyProperty(REQUIRED_APPROVERS_KEY).ifPresent(n -> this.helper.saveCount(repository, ((Number)n).intValue()));
            return null;
        });
        return this.doGet(repository);
    }
}

