/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.approvers;

import com.atlassian.bitbucket.hook.repository.DisableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.GetRepositoryHookSettingsRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSettings;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.annotation.Nonnull;

public class RequiredApproversHelper {
    static final String APPROVERS_KEY = "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:requiredApproversMergeHook";
    static final String REQUIRED_COUNT = "requiredCount";
    private final RepositoryHookService repositoryHookService;
    private final SecurityService securityService;

    public RequiredApproversHelper(RepositoryHookService repositoryHookService, SecurityService securityService) {
        this.securityService = securityService;
        this.repositoryHookService = repositoryHookService;
    }

    void disable(Repository repository) {
        DisableRepositoryHookRequest request = new DisableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), APPROVERS_KEY).build();
        this.repositoryHookService.disable(request);
    }

    void enable(Repository repository, int count) {
        Settings settings = this.repositoryHookService.createSettingsBuilder().add(REQUIRED_COUNT, count).build();
        EnableRepositoryHookRequest request = new EnableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), APPROVERS_KEY).settings(settings).build();
        this.repositoryHookService.enable(request);
    }

    int getCount(Repository repository) {
        GetRepositoryHookSettingsRequest request;
        EscalatedSecurityContext withRepoAdmin = this.securityService.withPermission(Permission.REPO_ADMIN, "Getting required approval count");
        RepositoryHookSettings settings = (RepositoryHookSettings)withRepoAdmin.call(() -> this.lambda$getCount$0(request = new GetRepositoryHookSettingsRequest.Builder((Scope)Scopes.repository((Repository)repository), APPROVERS_KEY).build()));
        return settings == null ? 0 : settings.getSettings().getInt(REQUIRED_COUNT, 0);
    }

    int getCountDeprecated(Repository repository) {
        if (this.isEnabled(repository)) {
            return this.getCount(repository);
        }
        return 0;
    }

    boolean isEnabled(Repository repository) {
        EscalatedSecurityContext withRepoAdmin = this.securityService.withPermission(Permission.REPO_ADMIN, "Getting isEnabled for required approvers");
        RepositoryHook repositoryHook = (RepositoryHook)withRepoAdmin.call(() -> this.repositoryHookService.getByKey((Scope)Scopes.repository((Repository)repository), APPROVERS_KEY));
        return repositoryHook.isEnabled();
    }

    void saveCount(@Nonnull Repository repository, int count) {
        if (count > 0) {
            this.enable(repository, count);
        } else {
            this.disable(repository);
        }
    }

    private /* synthetic */ RepositoryHookSettings lambda$getCount$0(GetRepositoryHookSettingsRequest request) throws RuntimeException {
        return this.repositoryHookService.getSettings(request);
    }
}

