/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.approvers;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import jakarta.annotation.Nonnull;

public class RequiredApproversMergeCheck
implements RepositoryMergeCheck {
    private final I18nService i18nService;

    public RequiredApproversMergeCheck(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        int requiredCount = context.getSettings().getInt("requiredCount", 0);
        if (requiredCount <= 0) {
            return RepositoryHookResult.accepted();
        }
        int approvals = (int)request.getPullRequest().getReviewers().stream().filter(PullRequestParticipant::isApproved).count();
        int needed = requiredCount - approvals;
        if (needed >= 1) {
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.build.required.approvers.veto.short.message", new Object[0]), (String)this.i18nService.getMessage("bitbucket.requiredApprovers.veto.message", new Object[]{needed}));
        }
        return RepositoryHookResult.accepted();
    }
}

