/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.approvers;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.hooks.approvers.RequiredApproversHelper;
import com.atlassian.stash.internal.plugin.upgrades.MergeCheckToHooksV2MigrationJob;
import com.atlassian.stash.internal.plugin.upgrades.MergeCheckToHooksV2UpgradeTask;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredApproversMergeCheckMigrationJob
implements MergeCheckToHooksV2MigrationJob {
    private static final Logger log = LoggerFactory.getLogger(MergeCheckToHooksV2UpgradeTask.class);
    private final PluginSettings pluginSettings;
    private final RequiredApproversHelper requiredApproversHelper;

    public RequiredApproversMergeCheckMigrationJob(PluginSettingsFactory factory, RequiredApproversHelper requiredApproversHelper) {
        this.pluginSettings = factory.createSettingsForKey("com.atlassian.bitbucket.server.bitbucket-bundled-hooks");
        this.requiredApproversHelper = requiredApproversHelper;
    }

    @Override
    public void cleanup(List<Integer> repositoryIds) {
        repositoryIds.forEach(repoId -> this.pluginSettings.remove(this.createKey((int)repoId)));
    }

    @Override
    public String getHookName() {
        return "Required approvers merge check";
    }

    @Override
    public boolean migrate(Repository repository) {
        Object settings = this.pluginSettings.get(this.createKey(repository.getId()));
        if (settings != null) {
            try {
                int requiredApprovers = Integer.parseInt(String.valueOf(settings));
                if (requiredApprovers > 0) {
                    this.requiredApproversHelper.saveCount(repository, requiredApprovers);
                    return true;
                }
            }
            catch (NumberFormatException ignored) {
                log.warn("Required approvers: Invalid plugin settings ''{}'' found for repository ''{}''", settings, (Object)repository.getId());
            }
        }
        return false;
    }

    private String createKey(int repositoryId) {
        return "repo." + repositoryId + ".requiredApproversCount";
    }
}

