/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.approvers;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragment;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.atlassian.stash.internal.plugin.hooks.approvers.RequiredApproversHelper;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;

public class RequiredApproversRestFragment
implements RestFragment {
    static final String FRAGMENT_KEY = "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:requiredApprovers";
    static final String COUNT = "count";
    static final String ENABLE = "enable";
    private final RequiredApproversHelper helper;
    private final I18nService i18nService;

    public RequiredApproversRestFragment(RequiredApproversHelper helper, I18nService i18nService) {
        this.helper = helper;
        this.i18nService = i18nService;
    }

    @Nonnull
    public Map<String, Object> execute(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Repository repository = (Repository)requestContext.get("repository");
        if (fragmentContext.getMethod().equals("GET")) {
            return this.doGet(repository);
        }
        if (fragmentContext.getMethod().equals("POST")) {
            return this.doPost(fragmentContext, repository);
        }
        return ImmutableMap.of((Object)FRAGMENT_KEY, (Object)this.i18nService.getMessage("bitbucket.requiredApprovers.rest.method.unsupported", new Object[]{fragmentContext.getMethod()}));
    }

    @Nonnull
    public Map<String, Object> validate(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Optional property;
        if (fragmentContext.getMethod().equals("POST") && (property = fragmentContext.getBodyProperty(FRAGMENT_KEY)).isPresent()) {
            if (property.get() instanceof Map) {
                Map json = (Map)property.get();
                Object countObject = json.get(COUNT);
                Object enableObject = json.get(ENABLE);
                if (countObject == null) {
                    if (enableObject == null || !(enableObject instanceof Boolean)) {
                        return this.restInvalid();
                    }
                    boolean enable = (Boolean)enableObject;
                    if (enable) {
                        return new RestErrorMessage(FRAGMENT_KEY, this.i18nService.getMessage("bitbucket.requiredApprovers.rest.fragment.count.required", new Object[0]));
                    }
                } else {
                    if (!(countObject instanceof Number)) {
                        return this.restInvalid();
                    }
                    int count = ((Number)countObject).intValue();
                    if (count <= 0) {
                        return new RestErrorMessage(FRAGMENT_KEY, this.i18nService.getMessage("bitbucket.requiredApprovers.rest.fragment.count.nonpositive", new Object[0]));
                    }
                    if (enableObject != null) {
                        if (!(enableObject instanceof Boolean)) {
                            return this.restInvalid();
                        }
                        boolean enable = (Boolean)enableObject;
                        if (!enable) {
                            return new RestErrorMessage(FRAGMENT_KEY, this.i18nService.getMessage("bitbucket.requiredApprovers.rest.fragment.disable.hascount", new Object[0]));
                        }
                    }
                }
            } else {
                return this.restInvalid();
            }
        }
        return ImmutableMap.of();
    }

    private Map<String, Object> doGet(Repository repository) {
        return ImmutableMap.of((Object)FRAGMENT_KEY, (Object)ImmutableMap.of((Object)ENABLE, (Object)this.helper.isEnabled(repository), (Object)COUNT, (Object)this.helper.getCount(repository)));
    }

    private Map<String, Object> doPost(RestFragmentContext fragmentContext, Repository repository) {
        fragmentContext.getBodyProperty(FRAGMENT_KEY).map(property -> (Map)property).ifPresent(property -> {
            boolean enable = (Boolean)property.get(ENABLE);
            if (enable) {
                int count = ((Number)property.get(COUNT)).intValue();
                this.helper.enable(repository, count);
            } else {
                this.helper.disable(repository);
            }
        });
        return this.doGet(repository);
    }

    private Map<String, Object> restInvalid() {
        return new RestErrorMessage(FRAGMENT_KEY, this.i18nService.getMessage("bitbucket.requiredApprovers.rest.fragment.invalid", new Object[0]));
    }
}

