/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.approvers;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.setting.SettingsValidationErrors;
import com.atlassian.bitbucket.setting.SettingsValidator;
import jakarta.annotation.Nonnull;

public class RequiredApproversValidator
implements SettingsValidator {
    private final I18nService i18nService;

    public RequiredApproversValidator(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public void validate(@Nonnull Settings settings, @Nonnull SettingsValidationErrors errors, @Nonnull Scope scope) {
        Integer requiredApprovers;
        try {
            requiredApprovers = settings.getInt("requiredCount");
        }
        catch (NumberFormatException e) {
            errors.addFieldError("requiredCount", this.i18nService.getMessage("bitbucket.requiredApprovers.count.notANumber", new Object[0]));
            return;
        }
        if (requiredApprovers == null) {
            errors.addFieldError("requiredCount", this.i18nService.getMessage("bitbucket.requiredApprovers.count.notprovided", new Object[0]));
        } else if (requiredApprovers <= 0) {
            errors.addFieldError("requiredCount", this.i18nService.getMessage("bitbucket.requiredApprovers.count.notpositive", new Object[0]));
        }
    }
}

