/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.banner;

import com.atlassian.bitbucket.dmz.admin.banner.DmzAnnouncementBannerService;
import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.hook.repository.SynchronousPreferred;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;

@SynchronousPreferred(asyncSupported=false)
public class AnnouncementBannerHook
implements PostRepositoryHook<RepositoryPushHookRequest> {
    @VisibleForTesting
    static final int DIVIDER_MAX_LENGTH = 80;
    private final DmzAnnouncementBannerService announcementBannerService;

    public AnnouncementBannerHook(@Nonnull DmzAnnouncementBannerService announcementBannerService) {
        this.announcementBannerService = announcementBannerService;
    }

    public void postUpdate(@Nonnull PostRepositoryHookContext context, @Nonnull RepositoryPushHookRequest request) {
        this.announcementBannerService.getActiveBanner().ifPresent(banner -> request.getScmHookDetails().map(ScmHookDetails::out).ifPresent(out -> this.print(banner.getMessage(), (PrintWriter)out)));
    }

    private void print(String announcement, PrintWriter out) {
        String divider = StringUtils.repeat((char)'=', (int)Math.min(announcement.length(), 80));
        out.println();
        out.println(divider);
        out.println(announcement);
        out.println(divider);
        out.println();
    }
}

