/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.branchlinks;

import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.hook.repository.SynchronousPreferred;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import jakarta.annotation.Nonnull;
import java.io.PrintWriter;

@SynchronousPreferred(asyncSupported=false)
public class PrintBranchLinksHook
implements PostRepositoryHook<RepositoryPushHookRequest> {
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final PullRequestService pullRequestService;
    private final RefService refService;

    public PrintBranchLinksHook(I18nService i18nService, NavBuilder navBuilder, PullRequestService pullRequestService, RefService refService) {
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.pullRequestService = pullRequestService;
        this.refService = refService;
    }

    public void postUpdate(@Nonnull PostRepositoryHookContext context, @Nonnull RepositoryPushHookRequest request) {
        RefChange refChange;
        if (request.getRefChanges().size() != 1) {
            return;
        }
        Repository repository = request.getRepository();
        if (!this.shouldPrint(repository, refChange = (RefChange)request.getRefChanges().iterator().next())) {
            return;
        }
        request.getScmHookDetails().map(ScmHookDetails::out).ifPresent(out -> this.print(repository, refChange, (PrintWriter)out));
    }

    private boolean shouldPrint(Repository repository, RefChange refChange) {
        RefChangeType type;
        MinimalRef ref = refChange.getRef();
        if (StandardRefType.BRANCH.equals((Object)ref.getType()) && ((type = refChange.getType()) == RefChangeType.ADD || type == RefChangeType.UPDATE)) {
            String defaultBranchId = this.getDefaultBranchId(repository);
            return !ref.getId().equals(defaultBranchId);
        }
        return false;
    }

    private String getDefaultBranchId(Repository repository) {
        try {
            Branch defaultBranch = this.refService.getDefaultBranch(repository);
            return defaultBranch.getId();
        }
        catch (NoDefaultBranchException e) {
            return null;
        }
    }

    private void print(Repository repository, RefChange branchChange, PrintWriter out) {
        out.println();
        this.printBranchLinks(repository, branchChange, out);
        out.println();
    }

    private void printBranchLinks(Repository repository, RefChange branchChange, PrintWriter out) {
        MinimalRef ref = branchChange.getRef();
        if (branchChange.getType() == RefChangeType.ADD) {
            this.printCreatePullRequestLink(repository, ref, out);
        } else if (branchChange.getType() == RefChangeType.UPDATE) {
            PullRequestSearchRequest searchRequest = new PullRequestSearchRequest.Builder().repositoryAndBranch(PullRequestDirection.OUTGOING, Integer.valueOf(repository.getId()), ref.getId()).state(PullRequestState.OPEN).build();
            Page pullRequests = this.pullRequestService.search(searchRequest, (PageRequest)new PageRequestImpl(0, 10));
            if (pullRequests.getSize() != 0) {
                this.printPullRequestLinks((Page<PullRequest>)pullRequests, out);
            } else {
                this.printCreatePullRequestLink(repository, ref, out);
            }
        }
    }

    private void printCreatePullRequestLink(Repository repository, MinimalRef ref, PrintWriter out) {
        String branch = ref.getDisplayId();
        String createPullRequest = this.i18nService.getMessage("bitbucket.plugins.hooks.branchlinks.createPullRequest", new Object[]{branch});
        String createPullRequestUrl = this.navBuilder.repo(repository).createPullRequest().sourceBranch(ref.getId()).buildAbsolute();
        out.println(createPullRequest);
        out.print("  ");
        out.println(createPullRequestUrl);
    }

    private void printPullRequestLinks(Page<PullRequest> pullRequests, PrintWriter out) {
        for (PullRequest pr : pullRequests.getValues()) {
            String from = pr.getFromRef().getDisplayId();
            String to = pr.getToRef().getDisplayId();
            String viewPullRequest = this.i18nService.getMessage("bitbucket.plugins.hooks.branchlinks.viewPullRequest", new Object[]{from, to});
            String prUrl = this.navBuilder.repo(pr.getToRef().getRepository()).pullRequest(pr.getId()).buildAbsolute();
            out.println(viewPullRequest);
            out.print("  ");
            out.println(prUrl);
        }
        if (!pullRequests.getIsLastPage()) {
            out.println("  ...");
        }
    }
}

