/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.duplicatepullrequests;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import jakarta.annotation.Nonnull;
import java.util.stream.Collectors;

public class DuplicatePullRequestsMergeCheck
implements RepositoryMergeCheck {
    private final I18nService i18nService;
    private final PullRequestService pullRequestService;

    public DuplicatePullRequestsMergeCheck(I18nService i18nService, PullRequestService pullRequestService) {
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        PullRequest currentPullRequest = request.getPullRequest();
        Page pullRequests = this.pullRequestService.search(new PullRequestSearchRequest.Builder().fromRefId(currentPullRequest.getFromRef().getId()).fromRepositoryId(Integer.valueOf(currentPullRequest.getFromRef().getRepository().getId())).state(PullRequestState.OPEN).toRefId(currentPullRequest.getToRef().getId()).toRepositoryId(Integer.valueOf(currentPullRequest.getToRef().getRepository().getId())).withProperties(false).build(), PageUtils.newRequest((int)0, (int)50));
        if (pullRequests.getSize() > 1) {
            String ids = pullRequests.stream().map(pullRequest -> String.valueOf(pullRequest.getId())).sorted().collect(Collectors.joining(", #", "#", ""));
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.pull.require.no.duplicate.pullrequests.for.merge.label", new Object[0]), (String)this.i18nService.getMessage("bitbucket.pull.require.no.duplicate.pullrequests.for.merge.message", new Object[]{DuplicatePullRequestsMergeCheck.formatFromRef(currentPullRequest), currentPullRequest.getToRef().getDisplayId(), ids, pullRequests.getSize() - 1}));
        }
        return RepositoryHookResult.accepted();
    }

    private static String formatFromRef(PullRequest pullRequest) {
        PullRequestRef fromRef = pullRequest.getFromRef();
        if (pullRequest.isCrossRepository()) {
            Repository repository = fromRef.getRepository();
            return repository.getProject().getKey() + "/" + repository.getSlug() + ":" + fromRef.getDisplayId();
        }
        return fromRef.getDisplayId();
    }
}

