/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.forcepush;

import com.atlassian.bitbucket.hook.repository.CommitRemovedDetails;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.util.MoreCollectors;
import jakarta.annotation.Nonnull;
import java.util.List;

public class ForcePushHook
implements PreRepositoryHook<RepositoryPushHookRequest> {
    private final I18nService i18nService;

    public ForcePushHook(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryPushHookRequest request) {
        List updates = (List)request.getRefChanges().stream().filter(refChange -> refChange.getType() == RefChangeType.UPDATE).collect(MoreCollectors.toImmutableList());
        return updates.isEmpty() ? RepositoryHookResult.accepted() : updates.stream().filter(refChange -> refChange.getRef().getType() == StandardRefType.TAG).findFirst().map(this::rejectTagUpdate).orElseGet(() -> {
            context.registerCommitCallback((PreRepositoryHookCommitCallback)new ForcePushCommitCallback(), RepositoryHookCommitFilter.REMOVED_FROM_ANY_REF, new RepositoryHookCommitFilter[0]);
            return RepositoryHookResult.accepted();
        });
    }

    private RepositoryHookResult rejectRemovedCommit(CommitRemovedDetails details) {
        return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.plugins.hooks.forcepush.rejected", new Object[0]), (String)this.i18nService.getMessage("bitbucket.plugins.hooks.forcepush.rejected.details.commit", new Object[]{details.getCommit().getId(), details.getRef().getDisplayId()}));
    }

    private RepositoryHookResult rejectTagUpdate(RefChange refChange) {
        return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.plugins.hooks.forcepush.rejected", new Object[0]), (String)this.i18nService.getMessage("bitbucket.plugins.hooks.forcepush.rejected.details.tag", new Object[]{refChange.getRef().getDisplayId()}));
    }

    private class ForcePushCommitCallback
    implements PreRepositoryHookCommitCallback {
        private CommitRemovedDetails details;

        private ForcePushCommitCallback() {
        }

        @Nonnull
        public RepositoryHookResult getResult() {
            return this.details == null ? RepositoryHookResult.accepted() : ForcePushHook.this.rejectRemovedCommit(this.details);
        }

        public boolean onCommitRemoved(@Nonnull CommitRemovedDetails details) {
            this.details = details;
            return false;
        }
    }
}

