/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.moved;

import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.util.NamedLink;
import jakarta.annotation.Nonnull;
import java.io.PrintWriter;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryMovedHook
implements PreRepositoryHook<RepositoryPushHookRequest> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryMovedHook.class);
    private final I18nService i18nService;
    private final RequestManager requestManager;
    private final RepositoryService repositoryService;

    public RepositoryMovedHook(I18nService i18nService, RequestManager requestManager, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.requestManager = requestManager;
        this.repositoryService = repositoryService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryPushHookRequest request) {
        ScmHookDetails hookDetails = request.getScmHookDetails().orElse(null);
        if (hookDetails != null) {
            Repository repository = request.getRepository();
            try {
                String cloneUrl;
                RequestMetadata metadata = this.requestManager.getRequestMetadata();
                if (metadata == null || StringUtils.isBlank((CharSequence)metadata.getProtocol())) {
                    return RepositoryHookResult.accepted();
                }
                String requestProtocol = metadata.getProtocol();
                if ("https".equals(requestProtocol)) {
                    requestProtocol = "http";
                }
                if ((cloneUrl = (String)this.repositoryService.getCloneLinks(new RepositoryCloneLinksRequest.Builder().repository(repository).protocol(requestProtocol).build()).stream().findFirst().map(NamedLink::getHref).orElse(null)) != null && this.isMoved(repository, metadata, cloneUrl)) {
                    PrintWriter out = hookDetails.out();
                    out.println(this.i18nService.getMessage("bitbucket.repo.moved.message", new Object[0]));
                    out.println("  " + cloneUrl + "\n");
                }
            }
            catch (Exception e) {
                log.debug("[{}] checking whether the repository moved failed", (Object)repository, (Object)e);
            }
        }
        return RepositoryHookResult.accepted();
    }

    private boolean isMoved(Repository repository, RequestMetadata metadata, String cloneUrl) {
        String projectKey = StringUtils.lowerCase((String)repository.getProject().getKey());
        URI uri = URI.create(cloneUrl);
        String expectedFragment = StringUtils.lowerCase((String)uri.getPath());
        int index = expectedFragment.indexOf(projectKey);
        if (index == -1) {
            return false;
        }
        expectedFragment = expectedFragment.substring(index);
        String action = StringUtils.lowerCase((String)metadata.getAction());
        index = action.indexOf(expectedFragment);
        if (index == -1 && "git".equals(repository.getScmId())) {
            expectedFragment = StringUtils.removeEnd((String)expectedFragment, (String)".git");
            index = action.indexOf(expectedFragment);
        }
        if (index == -1) {
            return true;
        }
        if (index > 0 && !this.isSeparator(action.charAt(index - 1))) {
            return true;
        }
        int nextIndex = index + expectedFragment.length();
        return action.length() <= nextIndex || !this.isSeparator(action.charAt(nextIndex));
    }

    private boolean isSeparator(char c) {
        return c == '/' || c == '\'' || Character.isWhitespace(c);
    }
}

