/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.needswork;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;

public class NeedsWorkMergeCheck
implements RepositoryMergeCheck {
    private final I18nService i18nService;

    public NeedsWorkMergeCheck(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        List needsWorkUsers = request.getPullRequest().getReviewers().stream().filter(reviewer -> reviewer.getStatus() == PullRequestParticipantStatus.NEEDS_WORK).map(reviewer -> reviewer.getUser().getDisplayName()).collect(Collectors.toList());
        if (!needsWorkUsers.isEmpty()) {
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.plugins.hooks.needswork.label", new Object[0]), (String)this.i18nService.getMessage("bitbucket.plugins.hooks.needswork.message", new Object[]{String.join((CharSequence)", ", needsWorkUsers)}));
        }
        return RepositoryHookResult.accepted();
    }
}

