/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.task;

import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentService;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import jakarta.annotation.Nonnull;

public class IncompleteTasksMergeCheck
implements RepositoryMergeCheck {
    private final CommentService commentService;
    private final I18nService i18nService;

    public IncompleteTasksMergeCheck(CommentService commentService, I18nService i18nService) {
        this.commentService = commentService;
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        Page comments = this.commentService.search(new CommentSearchRequest.Builder((Commentable)request.getPullRequest()).anchorState(CommentThreadDiffAnchorState.ALL).severity(CommentSeverity.BLOCKER).state(CommentState.OPEN).build(), PageUtils.newRequest((int)0, (int)1));
        if (comments.getSize() > 0) {
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.pull.task.resolved.label", new Object[0]), (String)this.i18nService.getMessage("bitbucket.pull.task.resolved.message", new Object[0]));
        }
        return RepositoryHookResult.accepted();
    }
}

